<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \ServiceType\Cancel($options);
/**
 * Sample call for cancelReservation operation/method
 */
if ($cancel->cancelReservation(new \StructType\OTA_CancelRQ()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for pingProviders operation/method
 */
if ($ping->pingProviders(new \StructType\PingRequest()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createRoomReservation operation/method
 */
if ($create->createRoomReservation(new \StructType\OTA_HotelResRQ()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for View ServiceType
 */
$view = new \ServiceType\View($options);
/**
 * Sample call for viewReservation operation/method
 */
if ($view->viewReservation(new \StructType\OTA_ReadRQ()) !== false) {
    print_r($view->getResult());
} else {
    print_r($view->getLastError());
}
/**
 * Samples for Hotel ServiceType
 */
$hotel = new \ServiceType\Hotel($options);
/**
 * Sample call for hotelAvailabilityAndRates operation/method
 */
if ($hotel->hotelAvailabilityAndRates(new \StructType\OTA_HotelAvailRQ()) !== false) {
    print_r($hotel->getResult());
} else {
    print_r($hotel->getLastError());
}
