<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Verification StructType
 * @subpackage Structs
 */
class Verification extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PersonName
     */
    public $PersonName;
    /**
     * The ReservationTimeSpan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReservationTimeSpan
     */
    public $ReservationTimeSpan;
    /**
     * The Vendor
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Vendor[]
     */
    public $Vendor;
    /**
     * Constructor method for Verification
     * @uses Verification::setPersonName()
     * @uses Verification::setReservationTimeSpan()
     * @uses Verification::setVendor()
     * @param \StructType\PersonName $personName
     * @param \StructType\ReservationTimeSpan $reservationTimeSpan
     * @param \StructType\Vendor[] $vendor
     */
    public function __construct(\StructType\PersonName $personName = null, \StructType\ReservationTimeSpan $reservationTimeSpan = null, array $vendor = array())
    {
        $this
            ->setPersonName($personName)
            ->setReservationTimeSpan($reservationTimeSpan)
            ->setVendor($vendor);
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\PersonName $personName
     * @return \StructType\Verification
     */
    public function setPersonName(\StructType\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get ReservationTimeSpan value
     * @return \StructType\ReservationTimeSpan|null
     */
    public function getReservationTimeSpan()
    {
        return $this->ReservationTimeSpan;
    }
    /**
     * Set ReservationTimeSpan value
     * @param \StructType\ReservationTimeSpan $reservationTimeSpan
     * @return \StructType\Verification
     */
    public function setReservationTimeSpan(\StructType\ReservationTimeSpan $reservationTimeSpan = null)
    {
        $this->ReservationTimeSpan = $reservationTimeSpan;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \StructType\Vendor[]|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * This method is responsible for validating the values passed to the setVendor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorForArrayConstraintsFromSetVendor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verificationVendorItem) {
            // validation for constraint: itemType
            if (!$verificationVendorItem instanceof \StructType\Vendor) {
                $invalidValues[] = is_object($verificationVendorItem) ? get_class($verificationVendorItem) : sprintf('%s(%s)', gettype($verificationVendorItem), var_export($verificationVendorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vendor property can only contain items of type \StructType\Vendor, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vendor value
     * @throws \InvalidArgumentException
     * @param \StructType\Vendor[] $vendor
     * @return \StructType\Verification
     */
    public function setVendor(array $vendor = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorArrayErrorMessage = self::validateVendorForArrayConstraintsFromSetVendor($vendor))) {
            throw new \InvalidArgumentException($vendorArrayErrorMessage, __LINE__);
        }
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Add item to Vendor value
     * @throws \InvalidArgumentException
     * @param \StructType\Vendor $item
     * @return \StructType\Verification
     */
    public function addToVendor(\StructType\Vendor $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Vendor) {
            throw new \InvalidArgumentException(sprintf('The Vendor property can only contain items of type \StructType\Vendor, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vendor[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Verification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
