<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transactions StructType
 * @subpackage Structs
 */
class Transactions extends AbstractStructBase
{
    /**
     * The Transaction
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transaction[]
     */
    public $Transaction;
    /**
     * Constructor method for Transactions
     * @uses Transactions::setTransaction()
     * @param \StructType\Transaction[] $transaction
     */
    public function __construct(array $transaction = array())
    {
        $this
            ->setTransaction($transaction);
    }
    /**
     * Get Transaction value
     * @return \StructType\Transaction[]|null
     */
    public function getTransaction()
    {
        return $this->Transaction;
    }
    /**
     * This method is responsible for validating the values passed to the setTransaction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransaction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransactionForArrayConstraintsFromSetTransaction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transactionsTransactionItem) {
            // validation for constraint: itemType
            if (!$transactionsTransactionItem instanceof \StructType\Transaction) {
                $invalidValues[] = is_object($transactionsTransactionItem) ? get_class($transactionsTransactionItem) : sprintf('%s(%s)', gettype($transactionsTransactionItem), var_export($transactionsTransactionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transaction property can only contain items of type \StructType\Transaction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\Transaction[] $transaction
     * @return \StructType\Transactions
     */
    public function setTransaction(array $transaction = array())
    {
        // validation for constraint: array
        if ('' !== ($transactionArrayErrorMessage = self::validateTransactionForArrayConstraintsFromSetTransaction($transaction))) {
            throw new \InvalidArgumentException($transactionArrayErrorMessage, __LINE__);
        }
        $this->Transaction = $transaction;
        return $this;
    }
    /**
     * Add item to Transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\Transaction $item
     * @return \StructType\Transactions
     */
    public function addToTransaction(\StructType\Transaction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transaction) {
            throw new \InvalidArgumentException(sprintf('The Transaction property can only contain items of type \StructType\Transaction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transaction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Transactions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
