<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpaExtension StructType
 * @subpackage Structs
 */
class TpaExtension extends AbstractStructBase
{
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Extension[]
     */
    public $Extension;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * Constructor method for TpaExtension
     * @uses TpaExtension::setExtension()
     * @uses TpaExtension::setID()
     * @param \StructType\Extension[] $extension
     * @param string $iD
     */
    public function __construct(array $extension = array(), $iD = null)
    {
        $this
            ->setExtension($extension)
            ->setID($iD);
    }
    /**
     * Get Extension value
     * @return \StructType\Extension[]|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * This method is responsible for validating the values passed to the setExtension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExtension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExtensionForArrayConstraintsFromSetExtension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tpaExtensionExtensionItem) {
            // validation for constraint: itemType
            if (!$tpaExtensionExtensionItem instanceof \StructType\Extension) {
                $invalidValues[] = is_object($tpaExtensionExtensionItem) ? get_class($tpaExtensionExtensionItem) : sprintf('%s(%s)', gettype($tpaExtensionExtensionItem), var_export($tpaExtensionExtensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Extension property can only contain items of type \StructType\Extension, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Extension value
     * @throws \InvalidArgumentException
     * @param \StructType\Extension[] $extension
     * @return \StructType\TpaExtension
     */
    public function setExtension(array $extension = array())
    {
        // validation for constraint: array
        if ('' !== ($extensionArrayErrorMessage = self::validateExtensionForArrayConstraintsFromSetExtension($extension))) {
            throw new \InvalidArgumentException($extensionArrayErrorMessage, __LINE__);
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Add item to Extension value
     * @throws \InvalidArgumentException
     * @param \StructType\Extension $item
     * @return \StructType\TpaExtension
     */
    public function addToExtension(\StructType\Extension $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Extension) {
            throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of type \StructType\Extension, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Extension[] = $item;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\TpaExtension
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpaExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
