<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Telephone StructType
 * @subpackage Structs
 */
class Telephone extends AbstractStructBase
{
    /**
     * The FormattedInd
     * @var string
     */
    public $FormattedInd;
    /**
     * The PhoneLocationType
     * @var int
     */
    public $PhoneLocationType;
    /**
     * The PhoneNumber
     * @var string
     */
    public $PhoneNumber;
    /**
     * The PhoneTechType
     * @var int
     */
    public $PhoneTechType;
    /**
     * Constructor method for Telephone
     * @uses Telephone::setFormattedInd()
     * @uses Telephone::setPhoneLocationType()
     * @uses Telephone::setPhoneNumber()
     * @uses Telephone::setPhoneTechType()
     * @param string $formattedInd
     * @param int $phoneLocationType
     * @param string $phoneNumber
     * @param int $phoneTechType
     */
    public function __construct($formattedInd = null, $phoneLocationType = null, $phoneNumber = null, $phoneTechType = null)
    {
        $this
            ->setFormattedInd($formattedInd)
            ->setPhoneLocationType($phoneLocationType)
            ->setPhoneNumber($phoneNumber)
            ->setPhoneTechType($phoneTechType);
    }
    /**
     * Get FormattedInd value
     * @return string|null
     */
    public function getFormattedInd()
    {
        return $this->FormattedInd;
    }
    /**
     * Set FormattedInd value
     * @param string $formattedInd
     * @return \StructType\Telephone
     */
    public function setFormattedInd($formattedInd = null)
    {
        // validation for constraint: string
        if (!is_null($formattedInd) && !is_string($formattedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedInd, true), gettype($formattedInd)), __LINE__);
        }
        $this->FormattedInd = $formattedInd;
        return $this;
    }
    /**
     * Get PhoneLocationType value
     * @return int|null
     */
    public function getPhoneLocationType()
    {
        return $this->PhoneLocationType;
    }
    /**
     * Set PhoneLocationType value
     * @param int $phoneLocationType
     * @return \StructType\Telephone
     */
    public function setPhoneLocationType($phoneLocationType = null)
    {
        // validation for constraint: int
        if (!is_null($phoneLocationType) && !(is_int($phoneLocationType) || ctype_digit($phoneLocationType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($phoneLocationType, true), gettype($phoneLocationType)), __LINE__);
        }
        $this->PhoneLocationType = $phoneLocationType;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\Telephone
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get PhoneTechType value
     * @return int|null
     */
    public function getPhoneTechType()
    {
        return $this->PhoneTechType;
    }
    /**
     * Set PhoneTechType value
     * @param int $phoneTechType
     * @return \StructType\Telephone
     */
    public function setPhoneTechType($phoneTechType = null)
    {
        // validation for constraint: int
        if (!is_null($phoneTechType) && !(is_int($phoneTechType) || ctype_digit($phoneTechType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($phoneTechType, true), gettype($phoneTechType)), __LINE__);
        }
        $this->PhoneTechType = $phoneTechType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Telephone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
