<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupplementCharges StructType
 * @subpackage Structs
 */
class SupplementCharges extends AbstractStructBase
{
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Charge[]
     */
    public $Charge;
    /**
     * Constructor method for SupplementCharges
     * @uses SupplementCharges::setCharge()
     * @param \StructType\Charge[] $charge
     */
    public function __construct(array $charge = array())
    {
        $this
            ->setCharge($charge);
    }
    /**
     * Get Charge value
     * @return \StructType\Charge[]|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * This method is responsible for validating the values passed to the setCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeForArrayConstraintsFromSetCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplementChargesChargeItem) {
            // validation for constraint: itemType
            if (!$supplementChargesChargeItem instanceof \StructType\Charge) {
                $invalidValues[] = is_object($supplementChargesChargeItem) ? get_class($supplementChargesChargeItem) : sprintf('%s(%s)', gettype($supplementChargesChargeItem), var_export($supplementChargesChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Charge property can only contain items of type \StructType\Charge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Charge value
     * @throws \InvalidArgumentException
     * @param \StructType\Charge[] $charge
     * @return \StructType\SupplementCharges
     */
    public function setCharge(array $charge = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeArrayErrorMessage = self::validateChargeForArrayConstraintsFromSetCharge($charge))) {
            throw new \InvalidArgumentException($chargeArrayErrorMessage, __LINE__);
        }
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param \StructType\Charge $item
     * @return \StructType\SupplementCharges
     */
    public function addToCharge(\StructType\Charge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Charge) {
            throw new \InvalidArgumentException(sprintf('The Charge property can only contain items of type \StructType\Charge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Charge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SupplementCharges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
