<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubSection StructType
 * @subpackage Structs
 */
class SubSection extends AbstractStructBase
{
    /**
     * The Paragraph
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Paragraph
     */
    public $Paragraph;
    /**
     * The SubCode
     * @var string
     */
    public $SubCode;
    /**
     * Constructor method for SubSection
     * @uses SubSection::setParagraph()
     * @uses SubSection::setSubCode()
     * @param \StructType\Paragraph $paragraph
     * @param string $subCode
     */
    public function __construct(\StructType\Paragraph $paragraph = null, $subCode = null)
    {
        $this
            ->setParagraph($paragraph)
            ->setSubCode($subCode);
    }
    /**
     * Get Paragraph value
     * @return \StructType\Paragraph|null
     */
    public function getParagraph()
    {
        return $this->Paragraph;
    }
    /**
     * Set Paragraph value
     * @param \StructType\Paragraph $paragraph
     * @return \StructType\SubSection
     */
    public function setParagraph(\StructType\Paragraph $paragraph = null)
    {
        $this->Paragraph = $paragraph;
        return $this;
    }
    /**
     * Get SubCode value
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->SubCode;
    }
    /**
     * Set SubCode value
     * @param string $subCode
     * @return \StructType\SubSection
     */
    public function setSubCode($subCode = null)
    {
        // validation for constraint: string
        if (!is_null($subCode) && !is_string($subCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCode, true), gettype($subCode)), __LINE__);
        }
        $this->SubCode = $subCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubSection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
