<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRequests StructType
 * @subpackage Structs
 */
class SpecialRequests extends AbstractStructBase
{
    /**
     * The SpecialRequest
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecialRequest[]
     */
    public $SpecialRequest;
    /**
     * Constructor method for SpecialRequests
     * @uses SpecialRequests::setSpecialRequest()
     * @param \StructType\SpecialRequest[] $specialRequest
     */
    public function __construct(array $specialRequest = array())
    {
        $this
            ->setSpecialRequest($specialRequest);
    }
    /**
     * Get SpecialRequest value
     * @return \StructType\SpecialRequest[]|null
     */
    public function getSpecialRequest()
    {
        return $this->SpecialRequest;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialRequestForArrayConstraintsFromSetSpecialRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $specialRequestsSpecialRequestItem) {
            // validation for constraint: itemType
            if (!$specialRequestsSpecialRequestItem instanceof \StructType\SpecialRequest) {
                $invalidValues[] = is_object($specialRequestsSpecialRequestItem) ? get_class($specialRequestsSpecialRequestItem) : sprintf('%s(%s)', gettype($specialRequestsSpecialRequestItem), var_export($specialRequestsSpecialRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialRequest property can only contain items of type \StructType\SpecialRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialRequest[] $specialRequest
     * @return \StructType\SpecialRequests
     */
    public function setSpecialRequest(array $specialRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($specialRequestArrayErrorMessage = self::validateSpecialRequestForArrayConstraintsFromSetSpecialRequest($specialRequest))) {
            throw new \InvalidArgumentException($specialRequestArrayErrorMessage, __LINE__);
        }
        $this->SpecialRequest = $specialRequest;
        return $this;
    }
    /**
     * Add item to SpecialRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialRequest $item
     * @return \StructType\SpecialRequests
     */
    public function addToSpecialRequest(\StructType\SpecialRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialRequest) {
            throw new \InvalidArgumentException(sprintf('The SpecialRequest property can only contain items of type \StructType\SpecialRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialRequest[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialRequests
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
