<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Source StructType
 * @subpackage Structs
 */
class Source extends AbstractStructBase
{
    /**
     * The BookingChannel
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\BookingChannel
     */
    public $BookingChannel;
    /**
     * The RequestorID
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RequestorID
     */
    public $RequestorID;
    /**
     * The AgentDutyCode
     * @var string
     */
    public $AgentDutyCode;
    /**
     * The ERSP_UserID
     * @var string
     */
    public $ERSP_UserID;
    /**
     * The ISOCountry
     * @var string
     */
    public $ISOCountry;
    /**
     * The Position
     * @var string
     */
    public $Position;
    /**
     * The TerminalID
     * @var string
     */
    public $TerminalID;
    /**
     * Constructor method for Source
     * @uses Source::setBookingChannel()
     * @uses Source::setRequestorID()
     * @uses Source::setAgentDutyCode()
     * @uses Source::setERSP_UserID()
     * @uses Source::setISOCountry()
     * @uses Source::setPosition()
     * @uses Source::setTerminalID()
     * @param \StructType\BookingChannel $bookingChannel
     * @param \StructType\RequestorID $requestorID
     * @param string $agentDutyCode
     * @param string $eRSP_UserID
     * @param string $iSOCountry
     * @param string $position
     * @param string $terminalID
     */
    public function __construct(\StructType\BookingChannel $bookingChannel = null, \StructType\RequestorID $requestorID = null, $agentDutyCode = null, $eRSP_UserID = null, $iSOCountry = null, $position = null, $terminalID = null)
    {
        $this
            ->setBookingChannel($bookingChannel)
            ->setRequestorID($requestorID)
            ->setAgentDutyCode($agentDutyCode)
            ->setERSP_UserID($eRSP_UserID)
            ->setISOCountry($iSOCountry)
            ->setPosition($position)
            ->setTerminalID($terminalID);
    }
    /**
     * Get BookingChannel value
     * @return \StructType\BookingChannel|null
     */
    public function getBookingChannel()
    {
        return $this->BookingChannel;
    }
    /**
     * Set BookingChannel value
     * @param \StructType\BookingChannel $bookingChannel
     * @return \StructType\Source
     */
    public function setBookingChannel(\StructType\BookingChannel $bookingChannel = null)
    {
        $this->BookingChannel = $bookingChannel;
        return $this;
    }
    /**
     * Get RequestorID value
     * @return \StructType\RequestorID|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param \StructType\RequestorID $requestorID
     * @return \StructType\Source
     */
    public function setRequestorID(\StructType\RequestorID $requestorID = null)
    {
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get AgentDutyCode value
     * @return string|null
     */
    public function getAgentDutyCode()
    {
        return $this->AgentDutyCode;
    }
    /**
     * Set AgentDutyCode value
     * @param string $agentDutyCode
     * @return \StructType\Source
     */
    public function setAgentDutyCode($agentDutyCode = null)
    {
        // validation for constraint: string
        if (!is_null($agentDutyCode) && !is_string($agentDutyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentDutyCode, true), gettype($agentDutyCode)), __LINE__);
        }
        $this->AgentDutyCode = $agentDutyCode;
        return $this;
    }
    /**
     * Get ERSP_UserID value
     * @return string|null
     */
    public function getERSP_UserID()
    {
        return $this->ERSP_UserID;
    }
    /**
     * Set ERSP_UserID value
     * @param string $eRSP_UserID
     * @return \StructType\Source
     */
    public function setERSP_UserID($eRSP_UserID = null)
    {
        // validation for constraint: string
        if (!is_null($eRSP_UserID) && !is_string($eRSP_UserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eRSP_UserID, true), gettype($eRSP_UserID)), __LINE__);
        }
        $this->ERSP_UserID = $eRSP_UserID;
        return $this;
    }
    /**
     * Get ISOCountry value
     * @return string|null
     */
    public function getISOCountry()
    {
        return $this->ISOCountry;
    }
    /**
     * Set ISOCountry value
     * @param string $iSOCountry
     * @return \StructType\Source
     */
    public function setISOCountry($iSOCountry = null)
    {
        // validation for constraint: string
        if (!is_null($iSOCountry) && !is_string($iSOCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSOCountry, true), gettype($iSOCountry)), __LINE__);
        }
        $this->ISOCountry = $iSOCountry;
        return $this;
    }
    /**
     * Get Position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param string $position
     * @return \StructType\Source
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get TerminalID value
     * @return string|null
     */
    public function getTerminalID()
    {
        return $this->TerminalID;
    }
    /**
     * Set TerminalID value
     * @param string $terminalID
     * @return \StructType\Source
     */
    public function setTerminalID($terminalID = null)
    {
        // validation for constraint: string
        if (!is_null($terminalID) && !is_string($terminalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($terminalID, true), gettype($terminalID)), __LINE__);
        }
        $this->TerminalID = $terminalID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Source
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
