<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomProfile StructType
 * @subpackage Structs
 */
class RoomProfile extends AbstractStructBase
{
    /**
     * The RoomAmenity
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - form: qualified
     * - minOccurs: 0
     * @var string
     */
    public $RoomAmenity;
    /**
     * The SupplementCharges
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\SupplementCharges
     */
    public $SupplementCharges;
    /**
     * The PassengerRPHs
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PassengerRPHs
     */
    public $PassengerRPHs;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\GuestCounts
     */
    public $GuestCounts;
    /**
     * The Configuration
     * @var string
     */
    public $Configuration;
    /**
     * The RoomType
     * Meta information extracted from the WSDL
     * - ref: tns:RoomType
     * @var string
     */
    public $RoomType;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - ref: tns:RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * Constructor method for RoomProfile
     * @uses RoomProfile::setRoomAmenity()
     * @uses RoomProfile::setSupplementCharges()
     * @uses RoomProfile::setPassengerRPHs()
     * @uses RoomProfile::setGuestCounts()
     * @uses RoomProfile::setConfiguration()
     * @uses RoomProfile::setRoomType()
     * @uses RoomProfile::setRoomTypeCode()
     * @param string $roomAmenity
     * @param \StructType\SupplementCharges $supplementCharges
     * @param \StructType\PassengerRPHs $passengerRPHs
     * @param \StructType\GuestCounts $guestCounts
     * @param string $configuration
     * @param string $roomType
     * @param string $roomTypeCode
     */
    public function __construct($roomAmenity = null, \StructType\SupplementCharges $supplementCharges = null, \StructType\PassengerRPHs $passengerRPHs = null, \StructType\GuestCounts $guestCounts = null, $configuration = null, $roomType = null, $roomTypeCode = null)
    {
        $this
            ->setRoomAmenity($roomAmenity)
            ->setSupplementCharges($supplementCharges)
            ->setPassengerRPHs($passengerRPHs)
            ->setGuestCounts($guestCounts)
            ->setConfiguration($configuration)
            ->setRoomType($roomType)
            ->setRoomTypeCode($roomTypeCode);
    }
    /**
     * Get RoomAmenity value
     * @return string|null
     */
    public function getRoomAmenity()
    {
        return $this->RoomAmenity;
    }
    /**
     * Set RoomAmenity value
     * @param string $roomAmenity
     * @return \StructType\RoomProfile
     */
    public function setRoomAmenity($roomAmenity = null)
    {
        // validation for constraint: string
        if (!is_null($roomAmenity) && !is_string($roomAmenity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomAmenity, true), gettype($roomAmenity)), __LINE__);
        }
        $this->RoomAmenity = $roomAmenity;
        return $this;
    }
    /**
     * Get SupplementCharges value
     * @return \StructType\SupplementCharges|null
     */
    public function getSupplementCharges()
    {
        return $this->SupplementCharges;
    }
    /**
     * Set SupplementCharges value
     * @param \StructType\SupplementCharges $supplementCharges
     * @return \StructType\RoomProfile
     */
    public function setSupplementCharges(\StructType\SupplementCharges $supplementCharges = null)
    {
        $this->SupplementCharges = $supplementCharges;
        return $this;
    }
    /**
     * Get PassengerRPHs value
     * @return \StructType\PassengerRPHs|null
     */
    public function getPassengerRPHs()
    {
        return $this->PassengerRPHs;
    }
    /**
     * Set PassengerRPHs value
     * @param \StructType\PassengerRPHs $passengerRPHs
     * @return \StructType\RoomProfile
     */
    public function setPassengerRPHs(\StructType\PassengerRPHs $passengerRPHs = null)
    {
        $this->PassengerRPHs = $passengerRPHs;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCounts|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCounts $guestCounts
     * @return \StructType\RoomProfile
     */
    public function setGuestCounts(\StructType\GuestCounts $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get Configuration value
     * @return string|null
     */
    public function getConfiguration()
    {
        return $this->Configuration;
    }
    /**
     * Set Configuration value
     * @param string $configuration
     * @return \StructType\RoomProfile
     */
    public function setConfiguration($configuration = null)
    {
        // validation for constraint: string
        if (!is_null($configuration) && !is_string($configuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configuration, true), gettype($configuration)), __LINE__);
        }
        $this->Configuration = $configuration;
        return $this;
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\RoomProfile
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomProfile
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
