<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reservationList StructType
 * @subpackage Structs
 */
class ReservationList extends AbstractStructBase
{
    /**
     * The HotelReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ns1:HotelReservation
     * @var \StructType\HotelReservation[]
     */
    public $HotelReservation;
    /**
     * The PackageReservation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ns1:PackageReservation
     * @var \StructType\PackageReservation[]
     */
    public $PackageReservation;
    /**
     * Constructor method for reservationList
     * @uses ReservationList::setHotelReservation()
     * @uses ReservationList::setPackageReservation()
     * @param \StructType\HotelReservation[] $hotelReservation
     * @param \StructType\PackageReservation[] $packageReservation
     */
    public function __construct(array $hotelReservation = array(), array $packageReservation = array())
    {
        $this
            ->setHotelReservation($hotelReservation)
            ->setPackageReservation($packageReservation);
    }
    /**
     * Get HotelReservation value
     * @return \StructType\HotelReservation[]|null
     */
    public function getHotelReservation()
    {
        return $this->HotelReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelReservationForArrayConstraintsFromSetHotelReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationListHotelReservationItem) {
            // validation for constraint: itemType
            if (!$reservationListHotelReservationItem instanceof \StructType\HotelReservation) {
                $invalidValues[] = is_object($reservationListHotelReservationItem) ? get_class($reservationListHotelReservationItem) : sprintf('%s(%s)', gettype($reservationListHotelReservationItem), var_export($reservationListHotelReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelReservation property can only contain items of type \StructType\HotelReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReservation[] $hotelReservation
     * @return \StructType\ReservationList
     */
    public function setHotelReservation(array $hotelReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelReservationArrayErrorMessage = self::validateHotelReservationForArrayConstraintsFromSetHotelReservation($hotelReservation))) {
            throw new \InvalidArgumentException($hotelReservationArrayErrorMessage, __LINE__);
        }
        $this->HotelReservation = $hotelReservation;
        return $this;
    }
    /**
     * Add item to HotelReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReservation $item
     * @return \StructType\ReservationList
     */
    public function addToHotelReservation(\StructType\HotelReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelReservation) {
            throw new \InvalidArgumentException(sprintf('The HotelReservation property can only contain items of type \StructType\HotelReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelReservation[] = $item;
        return $this;
    }
    /**
     * Get PackageReservation value
     * @return \StructType\PackageReservation[]|null
     */
    public function getPackageReservation()
    {
        return $this->PackageReservation;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageReservation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageReservation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageReservationForArrayConstraintsFromSetPackageReservation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $reservationListPackageReservationItem) {
            // validation for constraint: itemType
            if (!$reservationListPackageReservationItem instanceof \StructType\PackageReservation) {
                $invalidValues[] = is_object($reservationListPackageReservationItem) ? get_class($reservationListPackageReservationItem) : sprintf('%s(%s)', gettype($reservationListPackageReservationItem), var_export($reservationListPackageReservationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageReservation property can only contain items of type \StructType\PackageReservation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageReservation[] $packageReservation
     * @return \StructType\ReservationList
     */
    public function setPackageReservation(array $packageReservation = array())
    {
        // validation for constraint: array
        if ('' !== ($packageReservationArrayErrorMessage = self::validatePackageReservationForArrayConstraintsFromSetPackageReservation($packageReservation))) {
            throw new \InvalidArgumentException($packageReservationArrayErrorMessage, __LINE__);
        }
        $this->PackageReservation = $packageReservation;
        return $this;
    }
    /**
     * Add item to PackageReservation value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageReservation $item
     * @return \StructType\ReservationList
     */
    public function addToPackageReservation(\StructType\PackageReservation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageReservation) {
            throw new \InvalidArgumentException(sprintf('The PackageReservation property can only contain items of type \StructType\PackageReservation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageReservation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReservationList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
