<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResGuest StructType
 * @subpackage Structs
 */
class ResGuest extends AbstractStructBase
{
    /**
     * The ArrivalTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalTime;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Profiles
     */
    public $Profiles;
    /**
     * The AgeQualifyingCode
     * @var int
     */
    public $AgeQualifyingCode;
    /**
     * The ResGuestRPH
     * @var int
     */
    public $ResGuestRPH;
    /**
     * Constructor method for ResGuest
     * @uses ResGuest::setArrivalTime()
     * @uses ResGuest::setProfiles()
     * @uses ResGuest::setAgeQualifyingCode()
     * @uses ResGuest::setResGuestRPH()
     * @param string $arrivalTime
     * @param \StructType\Profiles $profiles
     * @param int $ageQualifyingCode
     * @param int $resGuestRPH
     */
    public function __construct($arrivalTime = null, \StructType\Profiles $profiles = null, $ageQualifyingCode = null, $resGuestRPH = null)
    {
        $this
            ->setArrivalTime($arrivalTime)
            ->setProfiles($profiles)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setResGuestRPH($resGuestRPH);
    }
    /**
     * Get ArrivalTime value
     * @return string|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @param string $arrivalTime
     * @return \StructType\ResGuest
     */
    public function setArrivalTime($arrivalTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalTime) && !is_string($arrivalTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalTime, true), gettype($arrivalTime)), __LINE__);
        }
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Get Profiles value
     * @return \StructType\Profiles|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \StructType\Profiles $profiles
     * @return \StructType\ResGuest
     */
    public function setProfiles(\StructType\Profiles $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return int|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param int $ageQualifyingCode
     * @return \StructType\ResGuest
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: int
        if (!is_null($ageQualifyingCode) && !(is_int($ageQualifyingCode) || ctype_digit($ageQualifyingCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get ResGuestRPH value
     * @return int|null
     */
    public function getResGuestRPH()
    {
        return $this->ResGuestRPH;
    }
    /**
     * Set ResGuestRPH value
     * @param int $resGuestRPH
     * @return \StructType\ResGuest
     */
    public function setResGuestRPH($resGuestRPH = null)
    {
        // validation for constraint: int
        if (!is_null($resGuestRPH) && !(is_int($resGuestRPH) || ctype_digit($resGuestRPH))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resGuestRPH, true), gettype($resGuestRPH)), __LINE__);
        }
        $this->ResGuestRPH = $resGuestRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResGuest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
