<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rateRange StructType
 * @subpackage Structs
 */
class RateRange extends AbstractStructBase
{
    /**
     * The DecimalPlaces
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MaxRate
     * @var string
     */
    public $MaxRate;
    /**
     * The MinRate
     * @var string
     */
    public $MinRate;
    /**
     * The RateTimeUnit
     * @var string
     */
    public $RateTimeUnit;
    /**
     * The RoomStayCandidateRPH
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * Constructor method for rateRange
     * @uses RateRange::setDecimalPlaces()
     * @uses RateRange::setCurrencyCode()
     * @uses RateRange::setMaxRate()
     * @uses RateRange::setMinRate()
     * @uses RateRange::setRateTimeUnit()
     * @uses RateRange::setRoomStayCandidateRPH()
     * @param int $decimalPlaces
     * @param string $currencyCode
     * @param string $maxRate
     * @param string $minRate
     * @param string $rateTimeUnit
     * @param string $roomStayCandidateRPH
     */
    public function __construct($decimalPlaces = null, $currencyCode = null, $maxRate = null, $minRate = null, $rateTimeUnit = null, $roomStayCandidateRPH = null)
    {
        $this
            ->setDecimalPlaces($decimalPlaces)
            ->setCurrencyCode($currencyCode)
            ->setMaxRate($maxRate)
            ->setMinRate($minRate)
            ->setRateTimeUnit($rateTimeUnit)
            ->setRoomStayCandidateRPH($roomStayCandidateRPH);
    }
    /**
     * Get DecimalPlaces value
     * @return int
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\RateRange
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\RateRange
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MaxRate value
     * @return string|null
     */
    public function getMaxRate()
    {
        return $this->MaxRate;
    }
    /**
     * Set MaxRate value
     * @param string $maxRate
     * @return \StructType\RateRange
     */
    public function setMaxRate($maxRate = null)
    {
        // validation for constraint: string
        if (!is_null($maxRate) && !is_string($maxRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxRate, true), gettype($maxRate)), __LINE__);
        }
        $this->MaxRate = $maxRate;
        return $this;
    }
    /**
     * Get MinRate value
     * @return string|null
     */
    public function getMinRate()
    {
        return $this->MinRate;
    }
    /**
     * Set MinRate value
     * @param string $minRate
     * @return \StructType\RateRange
     */
    public function setMinRate($minRate = null)
    {
        // validation for constraint: string
        if (!is_null($minRate) && !is_string($minRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minRate, true), gettype($minRate)), __LINE__);
        }
        $this->MinRate = $minRate;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @param string $rateTimeUnit
     * @return \StructType\RateRange
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($rateTimeUnit) && !is_string($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateTimeUnit, true), gettype($rateTimeUnit)), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \StructType\RateRange
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayCandidateRPH, true), gettype($roomStayCandidateRPH)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
