<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlan StructType
 * @subpackage Structs
 */
class RatePlan extends AbstractStructBase
{
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\CancelPenalties
     */
    public $CancelPenalties;
    /**
     * The RatePlanDescription
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RatePlanDescription
     */
    public $RatePlanDescription;
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Guarantee
     */
    public $Guarantee;
    /**
     * The MealsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MealsIncluded
     */
    public $MealsIncluded;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * @var string
     */
    public $RatePlanID;
    /**
     * The RatePlanName
     * @var string
     */
    public $RatePlanName;
    /**
     * The RateIndicator
     * @var string
     */
    public $RateIndicator;
    /**
     * The RatePlanType
     * @var string
     */
    public $RatePlanType;
    /**
     * Constructor method for RatePlan
     * @uses RatePlan::setCancelPenalties()
     * @uses RatePlan::setRatePlanDescription()
     * @uses RatePlan::setGuarantee()
     * @uses RatePlan::setMealsIncluded()
     * @uses RatePlan::setRatePlanCode()
     * @uses RatePlan::setRatePlanID()
     * @uses RatePlan::setRatePlanName()
     * @uses RatePlan::setRateIndicator()
     * @uses RatePlan::setRatePlanType()
     * @param \StructType\CancelPenalties $cancelPenalties
     * @param \StructType\RatePlanDescription $ratePlanDescription
     * @param \StructType\Guarantee $guarantee
     * @param \StructType\MealsIncluded $mealsIncluded
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param string $ratePlanName
     * @param string $rateIndicator
     * @param string $ratePlanType
     */
    public function __construct(\StructType\CancelPenalties $cancelPenalties = null, \StructType\RatePlanDescription $ratePlanDescription = null, \StructType\Guarantee $guarantee = null, \StructType\MealsIncluded $mealsIncluded = null, $ratePlanCode = null, $ratePlanID = null, $ratePlanName = null, $rateIndicator = null, $ratePlanType = null)
    {
        $this
            ->setCancelPenalties($cancelPenalties)
            ->setRatePlanDescription($ratePlanDescription)
            ->setGuarantee($guarantee)
            ->setMealsIncluded($mealsIncluded)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRatePlanName($ratePlanName)
            ->setRateIndicator($rateIndicator)
            ->setRatePlanType($ratePlanType);
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenalties|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenalties $cancelPenalties
     * @return \StructType\RatePlan
     */
    public function setCancelPenalties(\StructType\CancelPenalties $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get RatePlanDescription value
     * @return \StructType\RatePlanDescription|null
     */
    public function getRatePlanDescription()
    {
        return $this->RatePlanDescription;
    }
    /**
     * Set RatePlanDescription value
     * @param \StructType\RatePlanDescription $ratePlanDescription
     * @return \StructType\RatePlan
     */
    public function setRatePlanDescription(\StructType\RatePlanDescription $ratePlanDescription = null)
    {
        $this->RatePlanDescription = $ratePlanDescription;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return \StructType\Guarantee|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @param \StructType\Guarantee $guarantee
     * @return \StructType\RatePlan
     */
    public function setGuarantee(\StructType\Guarantee $guarantee = null)
    {
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Get MealsIncluded value
     * @return \StructType\MealsIncluded|null
     */
    public function getMealsIncluded()
    {
        return $this->MealsIncluded;
    }
    /**
     * Set MealsIncluded value
     * @param \StructType\MealsIncluded $mealsIncluded
     * @return \StructType\RatePlan
     */
    public function setMealsIncluded(\StructType\MealsIncluded $mealsIncluded = null)
    {
        $this->MealsIncluded = $mealsIncluded;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RatePlan
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\RatePlan
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RatePlanName value
     * @return string|null
     */
    public function getRatePlanName()
    {
        return $this->RatePlanName;
    }
    /**
     * Set RatePlanName value
     * @param string $ratePlanName
     * @return \StructType\RatePlan
     */
    public function setRatePlanName($ratePlanName = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanName) && !is_string($ratePlanName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanName, true), gettype($ratePlanName)), __LINE__);
        }
        $this->RatePlanName = $ratePlanName;
        return $this;
    }
    /**
     * Get RateIndicator value
     * @return string|null
     */
    public function getRateIndicator()
    {
        return $this->RateIndicator;
    }
    /**
     * Set RateIndicator value
     * @param string $rateIndicator
     * @return \StructType\RatePlan
     */
    public function setRateIndicator($rateIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($rateIndicator) && !is_string($rateIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateIndicator, true), gettype($rateIndicator)), __LINE__);
        }
        $this->RateIndicator = $rateIndicator;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\RatePlan
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlan
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
