<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Profile StructType
 * @subpackage Structs
 */
class Profile extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Customer
     */
    public $Customer;
    /**
     * The Affiliations
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Affiliations
     */
    public $Affiliations;
    /**
     * The ProfileType
     * @var int
     */
    public $ProfileType;
    /**
     * The RPH
     * @var int
     */
    public $RPH;
    /**
     * Constructor method for Profile
     * @uses Profile::setCustomer()
     * @uses Profile::setAffiliations()
     * @uses Profile::setProfileType()
     * @uses Profile::setRPH()
     * @param \StructType\Customer $customer
     * @param \StructType\Affiliations $affiliations
     * @param int $profileType
     * @param int $rPH
     */
    public function __construct(\StructType\Customer $customer = null, \StructType\Affiliations $affiliations = null, $profileType = null, $rPH = null)
    {
        $this
            ->setCustomer($customer)
            ->setAffiliations($affiliations)
            ->setProfileType($profileType)
            ->setRPH($rPH);
    }
    /**
     * Get Customer value
     * @return \StructType\Customer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\Customer $customer
     * @return \StructType\Profile
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get Affiliations value
     * @return \StructType\Affiliations|null
     */
    public function getAffiliations()
    {
        return $this->Affiliations;
    }
    /**
     * Set Affiliations value
     * @param \StructType\Affiliations $affiliations
     * @return \StructType\Profile
     */
    public function setAffiliations(\StructType\Affiliations $affiliations = null)
    {
        $this->Affiliations = $affiliations;
        return $this;
    }
    /**
     * Get ProfileType value
     * @return int|null
     */
    public function getProfileType()
    {
        return $this->ProfileType;
    }
    /**
     * Set ProfileType value
     * @param int $profileType
     * @return \StructType\Profile
     */
    public function setProfileType($profileType = null)
    {
        // validation for constraint: int
        if (!is_null($profileType) && !(is_int($profileType) || ctype_digit($profileType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileType, true), gettype($profileType)), __LINE__);
        }
        $this->ProfileType = $profileType;
        return $this;
    }
    /**
     * Get RPH value
     * @return int|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param int $rPH
     * @return \StructType\Profile
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: int
        if (!is_null($rPH) && !(is_int($rPH) || ctype_digit($rPH))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Profile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
