<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentPolicies StructType
 * @subpackage Structs
 */
class PaymentPolicies extends AbstractStructBase
{
    /**
     * The RequiredPayment
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RequiredPayment[]
     */
    public $RequiredPayment;
    /**
     * Constructor method for PaymentPolicies
     * @uses PaymentPolicies::setRequiredPayment()
     * @param \StructType\RequiredPayment[] $requiredPayment
     */
    public function __construct(array $requiredPayment = array())
    {
        $this
            ->setRequiredPayment($requiredPayment);
    }
    /**
     * Get RequiredPayment value
     * @return \StructType\RequiredPayment[]|null
     */
    public function getRequiredPayment()
    {
        return $this->RequiredPayment;
    }
    /**
     * This method is responsible for validating the values passed to the setRequiredPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequiredPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequiredPaymentForArrayConstraintsFromSetRequiredPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentPoliciesRequiredPaymentItem) {
            // validation for constraint: itemType
            if (!$paymentPoliciesRequiredPaymentItem instanceof \StructType\RequiredPayment) {
                $invalidValues[] = is_object($paymentPoliciesRequiredPaymentItem) ? get_class($paymentPoliciesRequiredPaymentItem) : sprintf('%s(%s)', gettype($paymentPoliciesRequiredPaymentItem), var_export($paymentPoliciesRequiredPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RequiredPayment property can only contain items of type \StructType\RequiredPayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RequiredPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\RequiredPayment[] $requiredPayment
     * @return \StructType\PaymentPolicies
     */
    public function setRequiredPayment(array $requiredPayment = array())
    {
        // validation for constraint: array
        if ('' !== ($requiredPaymentArrayErrorMessage = self::validateRequiredPaymentForArrayConstraintsFromSetRequiredPayment($requiredPayment))) {
            throw new \InvalidArgumentException($requiredPaymentArrayErrorMessage, __LINE__);
        }
        $this->RequiredPayment = $requiredPayment;
        return $this;
    }
    /**
     * Add item to RequiredPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\RequiredPayment $item
     * @return \StructType\PaymentPolicies
     */
    public function addToRequiredPayment(\StructType\RequiredPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RequiredPayment) {
            throw new \InvalidArgumentException(sprintf('The RequiredPayment property can only contain items of type \StructType\RequiredPayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RequiredPayment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentPolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
