<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageRefs StructType
 * @subpackage Structs
 */
class PackageRefs extends AbstractStructBase
{
    /**
     * The PackageRef
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PackageRef[]
     */
    public $PackageRef;
    /**
     * Constructor method for PackageRefs
     * @uses PackageRefs::setPackageRef()
     * @param \StructType\PackageRef[] $packageRef
     */
    public function __construct(array $packageRef = array())
    {
        $this
            ->setPackageRef($packageRef);
    }
    /**
     * Get PackageRef value
     * @return \StructType\PackageRef[]|null
     */
    public function getPackageRef()
    {
        return $this->PackageRef;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageRefForArrayConstraintsFromSetPackageRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageRefsPackageRefItem) {
            // validation for constraint: itemType
            if (!$packageRefsPackageRefItem instanceof \StructType\PackageRef) {
                $invalidValues[] = is_object($packageRefsPackageRefItem) ? get_class($packageRefsPackageRefItem) : sprintf('%s(%s)', gettype($packageRefsPackageRefItem), var_export($packageRefsPackageRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageRef property can only contain items of type \StructType\PackageRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageRef value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageRef[] $packageRef
     * @return \StructType\PackageRefs
     */
    public function setPackageRef(array $packageRef = array())
    {
        // validation for constraint: array
        if ('' !== ($packageRefArrayErrorMessage = self::validatePackageRefForArrayConstraintsFromSetPackageRef($packageRef))) {
            throw new \InvalidArgumentException($packageRefArrayErrorMessage, __LINE__);
        }
        $this->PackageRef = $packageRef;
        return $this;
    }
    /**
     * Add item to PackageRef value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageRef $item
     * @return \StructType\PackageRefs
     */
    public function addToPackageRef(\StructType\PackageRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageRef) {
            throw new \InvalidArgumentException(sprintf('The PackageRef property can only contain items of type \StructType\PackageRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageRef[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackageRefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
