<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageRef StructType
 * @subpackage Structs
 */
class PackageRef extends AbstractStructBase
{
    /**
     * The tourCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tourCode;
    /**
     * The ChainCode
     * @var string
     */
    public $ChainCode;
    /**
     * The PackageCityCode
     * @var string
     */
    public $PackageCityCode;
    /**
     * The PackageCode
     * @var string
     */
    public $PackageCode;
    /**
     * Constructor method for PackageRef
     * @uses PackageRef::setTourCode()
     * @uses PackageRef::setChainCode()
     * @uses PackageRef::setPackageCityCode()
     * @uses PackageRef::setPackageCode()
     * @param string $tourCode
     * @param string $chainCode
     * @param string $packageCityCode
     * @param string $packageCode
     */
    public function __construct($tourCode = null, $chainCode = null, $packageCityCode = null, $packageCode = null)
    {
        $this
            ->setTourCode($tourCode)
            ->setChainCode($chainCode)
            ->setPackageCityCode($packageCityCode)
            ->setPackageCode($packageCode);
    }
    /**
     * Get tourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->tourCode;
    }
    /**
     * Set tourCode value
     * @param string $tourCode
     * @return \StructType\PackageRef
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourCode, true), gettype($tourCode)), __LINE__);
        }
        $this->tourCode = $tourCode;
        return $this;
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \StructType\PackageRef
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chainCode, true), gettype($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get PackageCityCode value
     * @return string|null
     */
    public function getPackageCityCode()
    {
        return $this->PackageCityCode;
    }
    /**
     * Set PackageCityCode value
     * @param string $packageCityCode
     * @return \StructType\PackageRef
     */
    public function setPackageCityCode($packageCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageCityCode) && !is_string($packageCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageCityCode, true), gettype($packageCityCode)), __LINE__);
        }
        $this->PackageCityCode = $packageCityCode;
        return $this;
    }
    /**
     * Get PackageCode value
     * @return string|null
     */
    public function getPackageCode()
    {
        return $this->PackageCode;
    }
    /**
     * Set PackageCode value
     * @param string $packageCode
     * @return \StructType\PackageRef
     */
    public function setPackageCode($packageCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageCode) && !is_string($packageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageCode, true), gettype($packageCode)), __LINE__);
        }
        $this->PackageCode = $packageCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackageRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
