<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POS StructType
 * @subpackage Structs
 */
class POS extends AbstractStructBase
{
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Source[]
     */
    public $Source;
    /**
     * Constructor method for POS
     * @uses POS::setSource()
     * @param \StructType\Source[] $source
     */
    public function __construct(array $source = array())
    {
        $this
            ->setSource($source);
    }
    /**
     * Get Source value
     * @return \StructType\Source[]|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * This method is responsible for validating the values passed to the setSource method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSource method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSourceForArrayConstraintsFromSetSource(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pOSSourceItem) {
            // validation for constraint: itemType
            if (!$pOSSourceItem instanceof \StructType\Source) {
                $invalidValues[] = is_object($pOSSourceItem) ? get_class($pOSSourceItem) : sprintf('%s(%s)', gettype($pOSSourceItem), var_export($pOSSourceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Source property can only contain items of type \StructType\Source, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Source value
     * @throws \InvalidArgumentException
     * @param \StructType\Source[] $source
     * @return \StructType\POS
     */
    public function setSource(array $source = array())
    {
        // validation for constraint: array
        if ('' !== ($sourceArrayErrorMessage = self::validateSourceForArrayConstraintsFromSetSource($source))) {
            throw new \InvalidArgumentException($sourceArrayErrorMessage, __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Add item to Source value
     * @throws \InvalidArgumentException
     * @param \StructType\Source $item
     * @return \StructType\POS
     */
    public function addToSource(\StructType\Source $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Source) {
            throw new \InvalidArgumentException(sprintf('The Source property can only contain items of type \StructType\Source, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Source[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\POS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
