<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_ReadRQ StructType
 * Meta information extracted from the WSDL
 * - type: tns:OTA_ReadRQ
 * @subpackage Structs
 */
class OTA_ReadRQ extends AbstractStructBase
{
    /**
     * The ReadRequests
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\ReadRequests
     */
    public $ReadRequests;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * Constructor method for OTA_ReadRQ
     * @uses OTA_ReadRQ::setReadRequests()
     * @uses OTA_ReadRQ::setEchoToken()
     * @param \StructType\ReadRequests $readRequests
     * @param string $echoToken
     */
    public function __construct(\StructType\ReadRequests $readRequests = null, $echoToken = null)
    {
        $this
            ->setReadRequests($readRequests)
            ->setEchoToken($echoToken);
    }
    /**
     * Get ReadRequests value
     * @return \StructType\ReadRequests|null
     */
    public function getReadRequests()
    {
        return $this->ReadRequests;
    }
    /**
     * Set ReadRequests value
     * @param \StructType\ReadRequests $readRequests
     * @return \StructType\OTA_ReadRQ
     */
    public function setReadRequests(\StructType\ReadRequests $readRequests = null)
    {
        $this->ReadRequests = $readRequests;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_ReadRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_ReadRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
