<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelResRS StructType
 * Meta information extracted from the WSDL
 * - type: tns:OTA_HotelResRS
 * @subpackage Structs
 */
class OTA_HotelResRS extends AbstractStructBase
{
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Errors
     */
    public $Errors;
    /**
     * The HotelReservations
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\HotelReservations
     */
    public $HotelReservations;
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\POS
     */
    public $POS;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Success
     */
    public $Success;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Warnings
     */
    public $Warnings;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The ResResponseType
     * @var string
     */
    public $ResResponseType;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The TransactionIdentifier
     * Meta information extracted from the WSDL
     * - ref: tns:TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * Constructor method for OTA_HotelResRS
     * @uses OTA_HotelResRS::setErrors()
     * @uses OTA_HotelResRS::setHotelReservations()
     * @uses OTA_HotelResRS::setPOS()
     * @uses OTA_HotelResRS::setSuccess()
     * @uses OTA_HotelResRS::setWarnings()
     * @uses OTA_HotelResRS::setEchoToken()
     * @uses OTA_HotelResRS::setResResponseType()
     * @uses OTA_HotelResRS::setTarget()
     * @uses OTA_HotelResRS::setTimeStamp()
     * @uses OTA_HotelResRS::setTransactionIdentifier()
     * @uses OTA_HotelResRS::setVersion()
     * @param \StructType\Errors $errors
     * @param \StructType\HotelReservations $hotelReservations
     * @param \StructType\POS $pOS
     * @param \StructType\Success $success
     * @param \StructType\Warnings $warnings
     * @param string $echoToken
     * @param string $resResponseType
     * @param string $target
     * @param string $timeStamp
     * @param string $transactionIdentifier
     * @param string $version
     */
    public function __construct(\StructType\Errors $errors = null, \StructType\HotelReservations $hotelReservations = null, \StructType\POS $pOS = null, \StructType\Success $success = null, \StructType\Warnings $warnings = null, $echoToken = null, $resResponseType = null, $target = null, $timeStamp = null, $transactionIdentifier = null, $version = null)
    {
        $this
            ->setErrors($errors)
            ->setHotelReservations($hotelReservations)
            ->setPOS($pOS)
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setEchoToken($echoToken)
            ->setResResponseType($resResponseType)
            ->setTarget($target)
            ->setTimeStamp($timeStamp)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setVersion($version);
    }
    /**
     * Get Errors value
     * @return \StructType\Errors|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\Errors $errors
     * @return \StructType\OTA_HotelResRS
     */
    public function setErrors(\StructType\Errors $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get HotelReservations value
     * @return \StructType\HotelReservations|null
     */
    public function getHotelReservations()
    {
        return $this->HotelReservations;
    }
    /**
     * Set HotelReservations value
     * @param \StructType\HotelReservations $hotelReservations
     * @return \StructType\OTA_HotelResRS
     */
    public function setHotelReservations(\StructType\HotelReservations $hotelReservations = null)
    {
        $this->HotelReservations = $hotelReservations;
        return $this;
    }
    /**
     * Get POS value
     * @return \StructType\POS|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS $pOS
     * @return \StructType\OTA_HotelResRS
     */
    public function setPOS(\StructType\POS $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Success value
     * @return \StructType\Success|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \StructType\Success $success
     * @return \StructType\OTA_HotelResRS
     */
    public function setSuccess(\StructType\Success $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\Warnings $warnings
     * @return \StructType\OTA_HotelResRS
     */
    public function setWarnings(\StructType\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_HotelResRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get ResResponseType value
     * @return string|null
     */
    public function getResResponseType()
    {
        return $this->ResResponseType;
    }
    /**
     * Set ResResponseType value
     * @param string $resResponseType
     * @return \StructType\OTA_HotelResRS
     */
    public function setResResponseType($resResponseType = null)
    {
        // validation for constraint: string
        if (!is_null($resResponseType) && !is_string($resResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resResponseType, true), gettype($resResponseType)), __LINE__);
        }
        $this->ResResponseType = $resResponseType;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_HotelResRS
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_HotelResRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_HotelResRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\OTA_HotelResRS
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_HotelResRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
