<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelResRQ StructType
 * Meta information extracted from the WSDL
 * - type: tns:OTA_HotelResRQ
 * @subpackage Structs
 */
class OTA_HotelResRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\POS
     */
    public $POS;
    /**
     * The HotelReservations
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\HotelReservations
     */
    public $HotelReservations;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * The SequenceNmbr
     * @var string
     */
    public $SequenceNmbr;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * Constructor method for OTA_HotelResRQ
     * @uses OTA_HotelResRQ::setPOS()
     * @uses OTA_HotelResRQ::setHotelReservations()
     * @uses OTA_HotelResRQ::setEchoToken()
     * @uses OTA_HotelResRQ::setResStatus()
     * @uses OTA_HotelResRQ::setSequenceNmbr()
     * @uses OTA_HotelResRQ::setTarget()
     * @uses OTA_HotelResRQ::setTimeStamp()
     * @uses OTA_HotelResRQ::setTransactionIdentifier()
     * @uses OTA_HotelResRQ::setTransactionStatusCode()
     * @uses OTA_HotelResRQ::setVersion()
     * @param \StructType\POS $pOS
     * @param \StructType\HotelReservations $hotelReservations
     * @param string $echoToken
     * @param string $resStatus
     * @param string $sequenceNmbr
     * @param string $target
     * @param string $timeStamp
     * @param string $transactionIdentifier
     * @param string $transactionStatusCode
     * @param string $version
     */
    public function __construct(\StructType\POS $pOS = null, \StructType\HotelReservations $hotelReservations = null, $echoToken = null, $resStatus = null, $sequenceNmbr = null, $target = null, $timeStamp = null, $transactionIdentifier = null, $transactionStatusCode = null, $version = null)
    {
        $this
            ->setPOS($pOS)
            ->setHotelReservations($hotelReservations)
            ->setEchoToken($echoToken)
            ->setResStatus($resStatus)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTarget($target)
            ->setTimeStamp($timeStamp)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setVersion($version);
    }
    /**
     * Get POS value
     * @return \StructType\POS|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS $pOS
     * @return \StructType\OTA_HotelResRQ
     */
    public function setPOS(\StructType\POS $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get HotelReservations value
     * @return \StructType\HotelReservations|null
     */
    public function getHotelReservations()
    {
        return $this->HotelReservations;
    }
    /**
     * Set HotelReservations value
     * @param \StructType\HotelReservations $hotelReservations
     * @return \StructType\OTA_HotelResRQ
     */
    public function setHotelReservations(\StructType\HotelReservations $hotelReservations = null)
    {
        $this->HotelReservations = $hotelReservations;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_HotelResRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @param string $resStatus
     * @return \StructType\OTA_HotelResRQ
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: string
        if (!is_null($resStatus) && !is_string($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resStatus, true), gettype($resStatus)), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return string|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param string $sequenceNmbr
     * @return \StructType\OTA_HotelResRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNmbr) && !is_string($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequenceNmbr, true), gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_HotelResRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_HotelResRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_HotelResRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \StructType\OTA_HotelResRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionStatusCode, true), gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\OTA_HotelResRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_HotelResRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
