<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelAvailRQ StructType
 * Meta information extracted from the WSDL
 * - type: tns:OTA_HotelAvailRQ
 * @subpackage Structs
 */
class OTA_HotelAvailRQ extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\POS
     */
    public $POS;
    /**
     * The AvailRequestSegments
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\AvailRequestSegments
     */
    public $AvailRequestSegments;
    /**
     * The AllowPartialAvail
     * @var bool
     */
    public $AllowPartialAvail;
    /**
     * The AvailRatesOnly
     * @var bool
     */
    public $AvailRatesOnly;
    /**
     * The RequestedCurrency
     * @var string
     */
    public $RequestedCurrency;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The IsModify
     * @var bool
     */
    public $IsModify;
    /**
     * The RateRangeOnly
     * @var bool
     */
    public $RateRangeOnly;
    /**
     * The SortOrder
     * @var string
     */
    public $SortOrder;
    /**
     * The SummaryOnly
     * @var bool
     */
    public $SummaryOnly;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * Constructor method for OTA_HotelAvailRQ
     * @uses OTA_HotelAvailRQ::setPOS()
     * @uses OTA_HotelAvailRQ::setAvailRequestSegments()
     * @uses OTA_HotelAvailRQ::setAllowPartialAvail()
     * @uses OTA_HotelAvailRQ::setAvailRatesOnly()
     * @uses OTA_HotelAvailRQ::setRequestedCurrency()
     * @uses OTA_HotelAvailRQ::setEchoToken()
     * @uses OTA_HotelAvailRQ::setIsModify()
     * @uses OTA_HotelAvailRQ::setRateRangeOnly()
     * @uses OTA_HotelAvailRQ::setSortOrder()
     * @uses OTA_HotelAvailRQ::setSummaryOnly()
     * @uses OTA_HotelAvailRQ::setTarget()
     * @uses OTA_HotelAvailRQ::setTimeStamp()
     * @uses OTA_HotelAvailRQ::setTransactionIdentifier()
     * @uses OTA_HotelAvailRQ::setVersion()
     * @param \StructType\POS $pOS
     * @param \StructType\AvailRequestSegments $availRequestSegments
     * @param bool $allowPartialAvail
     * @param bool $availRatesOnly
     * @param string $requestedCurrency
     * @param string $echoToken
     * @param bool $isModify
     * @param bool $rateRangeOnly
     * @param string $sortOrder
     * @param bool $summaryOnly
     * @param string $target
     * @param string $timeStamp
     * @param string $transactionIdentifier
     * @param string $version
     */
    public function __construct(\StructType\POS $pOS = null, \StructType\AvailRequestSegments $availRequestSegments = null, $allowPartialAvail = null, $availRatesOnly = null, $requestedCurrency = null, $echoToken = null, $isModify = null, $rateRangeOnly = null, $sortOrder = null, $summaryOnly = null, $target = null, $timeStamp = null, $transactionIdentifier = null, $version = null)
    {
        $this
            ->setPOS($pOS)
            ->setAvailRequestSegments($availRequestSegments)
            ->setAllowPartialAvail($allowPartialAvail)
            ->setAvailRatesOnly($availRatesOnly)
            ->setRequestedCurrency($requestedCurrency)
            ->setEchoToken($echoToken)
            ->setIsModify($isModify)
            ->setRateRangeOnly($rateRangeOnly)
            ->setSortOrder($sortOrder)
            ->setSummaryOnly($summaryOnly)
            ->setTarget($target)
            ->setTimeStamp($timeStamp)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setVersion($version);
    }
    /**
     * Get POS value
     * @return \StructType\POS|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS $pOS
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setPOS(\StructType\POS $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get AvailRequestSegments value
     * @return \StructType\AvailRequestSegments|null
     */
    public function getAvailRequestSegments()
    {
        return $this->AvailRequestSegments;
    }
    /**
     * Set AvailRequestSegments value
     * @param \StructType\AvailRequestSegments $availRequestSegments
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setAvailRequestSegments(\StructType\AvailRequestSegments $availRequestSegments = null)
    {
        $this->AvailRequestSegments = $availRequestSegments;
        return $this;
    }
    /**
     * Get AllowPartialAvail value
     * @return bool|null
     */
    public function getAllowPartialAvail()
    {
        return $this->AllowPartialAvail;
    }
    /**
     * Set AllowPartialAvail value
     * @param bool $allowPartialAvail
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setAllowPartialAvail($allowPartialAvail = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPartialAvail) && !is_bool($allowPartialAvail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPartialAvail, true), gettype($allowPartialAvail)), __LINE__);
        }
        $this->AllowPartialAvail = $allowPartialAvail;
        return $this;
    }
    /**
     * Get AvailRatesOnly value
     * @return bool|null
     */
    public function getAvailRatesOnly()
    {
        return $this->AvailRatesOnly;
    }
    /**
     * Set AvailRatesOnly value
     * @param bool $availRatesOnly
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setAvailRatesOnly($availRatesOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($availRatesOnly) && !is_bool($availRatesOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availRatesOnly, true), gettype($availRatesOnly)), __LINE__);
        }
        $this->AvailRatesOnly = $availRatesOnly;
        return $this;
    }
    /**
     * Get RequestedCurrency value
     * @return string|null
     */
    public function getRequestedCurrency()
    {
        return $this->RequestedCurrency;
    }
    /**
     * Set RequestedCurrency value
     * @param string $requestedCurrency
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setRequestedCurrency($requestedCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($requestedCurrency) && !is_string($requestedCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedCurrency, true), gettype($requestedCurrency)), __LINE__);
        }
        $this->RequestedCurrency = $requestedCurrency;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get IsModify value
     * @return bool|null
     */
    public function getIsModify()
    {
        return $this->IsModify;
    }
    /**
     * Set IsModify value
     * @param bool $isModify
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setIsModify($isModify = null)
    {
        // validation for constraint: boolean
        if (!is_null($isModify) && !is_bool($isModify)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isModify, true), gettype($isModify)), __LINE__);
        }
        $this->IsModify = $isModify;
        return $this;
    }
    /**
     * Get RateRangeOnly value
     * @return bool|null
     */
    public function getRateRangeOnly()
    {
        return $this->RateRangeOnly;
    }
    /**
     * Set RateRangeOnly value
     * @param bool $rateRangeOnly
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setRateRangeOnly($rateRangeOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateRangeOnly) && !is_bool($rateRangeOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateRangeOnly, true), gettype($rateRangeOnly)), __LINE__);
        }
        $this->RateRangeOnly = $rateRangeOnly;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @param string $sortOrder
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: string
        if (!is_null($sortOrder) && !is_string($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortOrder, true), gettype($sortOrder)), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get SummaryOnly value
     * @return bool|null
     */
    public function getSummaryOnly()
    {
        return $this->SummaryOnly;
    }
    /**
     * Set SummaryOnly value
     * @param bool $summaryOnly
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setSummaryOnly($summaryOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($summaryOnly) && !is_bool($summaryOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($summaryOnly, true), gettype($summaryOnly)), __LINE__);
        }
        $this->SummaryOnly = $summaryOnly;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\OTA_HotelAvailRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_HotelAvailRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
