<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_CancelRS StructType
 * Meta information extracted from the WSDL
 * - type: tns:OTA_CancelRS
 * @subpackage Structs
 */
class OTA_CancelRS extends AbstractStructBase
{
    /**
     * The CancelInfoRS
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\CancelInfoRS
     */
    public $CancelInfoRS;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Errors
     */
    public $Errors;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Success
     */
    public $Success;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UniqueID[]
     */
    public $UniqueID;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Warnings
     */
    public $Warnings;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for OTA_CancelRS
     * @uses OTA_CancelRS::setCancelInfoRS()
     * @uses OTA_CancelRS::setErrors()
     * @uses OTA_CancelRS::setSuccess()
     * @uses OTA_CancelRS::setUniqueID()
     * @uses OTA_CancelRS::setWarnings()
     * @uses OTA_CancelRS::setEchoToken()
     * @uses OTA_CancelRS::setStatus()
     * @uses OTA_CancelRS::setTimeStamp()
     * @param \StructType\CancelInfoRS $cancelInfoRS
     * @param \StructType\Errors $errors
     * @param \StructType\Success $success
     * @param \StructType\UniqueID[] $uniqueID
     * @param \StructType\Warnings $warnings
     * @param string $echoToken
     * @param string $status
     * @param string $timeStamp
     */
    public function __construct(\StructType\CancelInfoRS $cancelInfoRS = null, \StructType\Errors $errors = null, \StructType\Success $success = null, array $uniqueID = array(), \StructType\Warnings $warnings = null, $echoToken = null, $status = null, $timeStamp = null)
    {
        $this
            ->setCancelInfoRS($cancelInfoRS)
            ->setErrors($errors)
            ->setSuccess($success)
            ->setUniqueID($uniqueID)
            ->setWarnings($warnings)
            ->setEchoToken($echoToken)
            ->setStatus($status)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get CancelInfoRS value
     * @return \StructType\CancelInfoRS|null
     */
    public function getCancelInfoRS()
    {
        return $this->CancelInfoRS;
    }
    /**
     * Set CancelInfoRS value
     * @param \StructType\CancelInfoRS $cancelInfoRS
     * @return \StructType\OTA_CancelRS
     */
    public function setCancelInfoRS(\StructType\CancelInfoRS $cancelInfoRS = null)
    {
        $this->CancelInfoRS = $cancelInfoRS;
        return $this;
    }
    /**
     * Get Errors value
     * @return \StructType\Errors|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \StructType\Errors $errors
     * @return \StructType\OTA_CancelRS
     */
    public function setErrors(\StructType\Errors $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Success value
     * @return \StructType\Success|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \StructType\Success $success
     * @return \StructType\OTA_CancelRS
     */
    public function setSuccess(\StructType\Success $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oTA_CancelRSUniqueIDItem) {
            // validation for constraint: itemType
            if (!$oTA_CancelRSUniqueIDItem instanceof \StructType\UniqueID) {
                $invalidValues[] = is_object($oTA_CancelRSUniqueIDItem) ? get_class($oTA_CancelRSUniqueIDItem) : sprintf('%s(%s)', gettype($oTA_CancelRSUniqueIDItem), var_export($oTA_CancelRSUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID[] $uniqueID
     * @return \StructType\OTA_CancelRS
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID $item
     * @return \StructType\OTA_CancelRS
     */
    public function addToUniqueID(\StructType\UniqueID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \StructType\Warnings|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \StructType\Warnings $warnings
     * @return \StructType\OTA_CancelRS
     */
    public function setWarnings(\StructType\Warnings $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\OTA_CancelRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\OTA_CancelRS
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\OTA_CancelRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OTA_CancelRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
