<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Name StructType
 * Meta information extracted from the WSDL
 * - type: xs:string
 * @subpackage Structs
 */
class Name extends AbstractStructBase
{
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns1:GivenName
     * @var string
     */
    public $GivenName;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns1:Surname
     * @var string
     */
    public $Surname;
    /**
     * The NameTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns1:NameTitle
     * @var string
     */
    public $NameTitle;
    /**
     * Constructor method for Name
     * @uses Name::setGivenName()
     * @uses Name::setSurname()
     * @uses Name::setNameTitle()
     * @param string $givenName
     * @param string $surname
     * @param string $nameTitle
     */
    public function __construct($givenName = null, $surname = null, $nameTitle = null)
    {
        $this
            ->setGivenName($givenName)
            ->setSurname($surname)
            ->setNameTitle($nameTitle);
    }
    /**
     * Get GivenName value
     * @return string|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @param string $givenName
     * @return \StructType\Name
     */
    public function setGivenName($givenName = null)
    {
        // validation for constraint: string
        if (!is_null($givenName) && !is_string($givenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($givenName, true), gettype($givenName)), __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\Name
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get NameTitle value
     * @return string|null
     */
    public function getNameTitle()
    {
        return $this->NameTitle;
    }
    /**
     * Set NameTitle value
     * @param string $nameTitle
     * @return \StructType\Name
     */
    public function setNameTitle($nameTitle = null)
    {
        // validation for constraint: string
        if (!is_null($nameTitle) && !is_string($nameTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameTitle, true), gettype($nameTitle)), __LINE__);
        }
        $this->NameTitle = $nameTitle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Name
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
