<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceDetail StructType
 * @subpackage Structs
 */
class InvoiceDetail extends AbstractStructBase
{
    /**
     * The BalanceDueAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BalanceDueAmount
     */
    public $BalanceDueAmount;
    /**
     * The Amount
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for InvoiceDetail
     * @uses InvoiceDetail::setBalanceDueAmount()
     * @uses InvoiceDetail::setAmount()
     * @uses InvoiceDetail::setCurrencyCode()
     * @param \StructType\BalanceDueAmount $balanceDueAmount
     * @param string $amount
     * @param string $currencyCode
     */
    public function __construct(\StructType\BalanceDueAmount $balanceDueAmount = null, $amount = null, $currencyCode = null)
    {
        $this
            ->setBalanceDueAmount($balanceDueAmount)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get BalanceDueAmount value
     * @return \StructType\BalanceDueAmount|null
     */
    public function getBalanceDueAmount()
    {
        return $this->BalanceDueAmount;
    }
    /**
     * Set BalanceDueAmount value
     * @param \StructType\BalanceDueAmount $balanceDueAmount
     * @return \StructType\InvoiceDetail
     */
    public function setBalanceDueAmount(\StructType\BalanceDueAmount $balanceDueAmount = null)
    {
        $this->BalanceDueAmount = $balanceDueAmount;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \StructType\InvoiceDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\InvoiceDetail
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
