<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guarantee StructType
 * @subpackage Structs
 */
class Guarantee extends AbstractStructBase
{
    /**
     * The GuaranteesAccepted
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\GuaranteesAccepted
     */
    public $GuaranteesAccepted;
    /**
     * The GuaranteeCode
     * @var string
     */
    public $GuaranteeCode;
    /**
     * The GuaranteeType
     * @var string
     */
    public $GuaranteeType;
    /**
     * Constructor method for Guarantee
     * @uses Guarantee::setGuaranteesAccepted()
     * @uses Guarantee::setGuaranteeCode()
     * @uses Guarantee::setGuaranteeType()
     * @param \StructType\GuaranteesAccepted $guaranteesAccepted
     * @param string $guaranteeCode
     * @param string $guaranteeType
     */
    public function __construct(\StructType\GuaranteesAccepted $guaranteesAccepted = null, $guaranteeCode = null, $guaranteeType = null)
    {
        $this
            ->setGuaranteesAccepted($guaranteesAccepted)
            ->setGuaranteeCode($guaranteeCode)
            ->setGuaranteeType($guaranteeType);
    }
    /**
     * Get GuaranteesAccepted value
     * @return \StructType\GuaranteesAccepted|null
     */
    public function getGuaranteesAccepted()
    {
        return $this->GuaranteesAccepted;
    }
    /**
     * Set GuaranteesAccepted value
     * @param \StructType\GuaranteesAccepted $guaranteesAccepted
     * @return \StructType\Guarantee
     */
    public function setGuaranteesAccepted(\StructType\GuaranteesAccepted $guaranteesAccepted = null)
    {
        $this->GuaranteesAccepted = $guaranteesAccepted;
        return $this;
    }
    /**
     * Get GuaranteeCode value
     * @return string|null
     */
    public function getGuaranteeCode()
    {
        return $this->GuaranteeCode;
    }
    /**
     * Set GuaranteeCode value
     * @param string $guaranteeCode
     * @return \StructType\Guarantee
     */
    public function setGuaranteeCode($guaranteeCode = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeCode) && !is_string($guaranteeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeCode, true), gettype($guaranteeCode)), __LINE__);
        }
        $this->GuaranteeCode = $guaranteeCode;
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @param string $guaranteeType
     * @return \StructType\Guarantee
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        // validation for constraint: string
        if (!is_null($guaranteeType) && !is_string($guaranteeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guaranteeType, true), gettype($guaranteeType)), __LINE__);
        }
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Guarantee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
