<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fee StructType
 * @subpackage Structs
 */
class Fee extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Description
     */
    public $Description;
    /**
     * The Amount
     * @var string
     */
    public $Amount;
    /**
     * The ChargeFrequency
     * @var string
     */
    public $ChargeFrequency;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for Fee
     * @uses Fee::setDescription()
     * @uses Fee::setAmount()
     * @uses Fee::setChargeFrequency()
     * @uses Fee::setCode()
     * @param \StructType\Description $description
     * @param string $amount
     * @param string $chargeFrequency
     * @param string $code
     */
    public function __construct(\StructType\Description $description = null, $amount = null, $chargeFrequency = null, $code = null)
    {
        $this
            ->setDescription($description)
            ->setAmount($amount)
            ->setChargeFrequency($chargeFrequency)
            ->setCode($code);
    }
    /**
     * Get Description value
     * @return \StructType\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Description $description
     * @return \StructType\Fee
     */
    public function setDescription(\StructType\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \StructType\Fee
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ChargeFrequency value
     * @return string|null
     */
    public function getChargeFrequency()
    {
        return $this->ChargeFrequency;
    }
    /**
     * Set ChargeFrequency value
     * @param string $chargeFrequency
     * @return \StructType\Fee
     */
    public function setChargeFrequency($chargeFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($chargeFrequency) && !is_string($chargeFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeFrequency, true), gettype($chargeFrequency)), __LINE__);
        }
        $this->ChargeFrequency = $chargeFrequency;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Fee
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
