<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Criterion StructType
 * @subpackage Structs
 */
class Criterion extends AbstractStructBase
{
    /**
     * The HotelRef
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\HotelRef
     */
    public $HotelRef;
    /**
     * The HotelRefs
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\HotelRefs
     */
    public $HotelRefs;
    /**
     * The PackageRef
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PackageRef
     */
    public $PackageRef;
    /**
     * The PackageRefs
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PackageRefs
     */
    public $PackageRefs;
    /**
     * The RatePlanCandidates
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RatePlanCandidates
     */
    public $RatePlanCandidates;
    /**
     * The RateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RateRange
     */
    public $RateRange;
    /**
     * The RoomStayCandidates
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RoomStayCandidates
     */
    public $RoomStayCandidates;
    /**
     * The StayDateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StayDateRange
     */
    public $StayDateRange;
    /**
     * The ImportanceType
     * @var string
     */
    public $ImportanceType;
    /**
     * Constructor method for Criterion
     * @uses Criterion::setHotelRef()
     * @uses Criterion::setHotelRefs()
     * @uses Criterion::setPackageRef()
     * @uses Criterion::setPackageRefs()
     * @uses Criterion::setRatePlanCandidates()
     * @uses Criterion::setRateRange()
     * @uses Criterion::setRoomStayCandidates()
     * @uses Criterion::setStayDateRange()
     * @uses Criterion::setImportanceType()
     * @param \StructType\HotelRef $hotelRef
     * @param \StructType\HotelRefs $hotelRefs
     * @param \StructType\PackageRef $packageRef
     * @param \StructType\PackageRefs $packageRefs
     * @param \StructType\RatePlanCandidates $ratePlanCandidates
     * @param \StructType\RateRange $rateRange
     * @param \StructType\RoomStayCandidates $roomStayCandidates
     * @param \StructType\StayDateRange $stayDateRange
     * @param string $importanceType
     */
    public function __construct(\StructType\HotelRef $hotelRef = null, \StructType\HotelRefs $hotelRefs = null, \StructType\PackageRef $packageRef = null, \StructType\PackageRefs $packageRefs = null, \StructType\RatePlanCandidates $ratePlanCandidates = null, \StructType\RateRange $rateRange = null, \StructType\RoomStayCandidates $roomStayCandidates = null, \StructType\StayDateRange $stayDateRange = null, $importanceType = null)
    {
        $this
            ->setHotelRef($hotelRef)
            ->setHotelRefs($hotelRefs)
            ->setPackageRef($packageRef)
            ->setPackageRefs($packageRefs)
            ->setRatePlanCandidates($ratePlanCandidates)
            ->setRateRange($rateRange)
            ->setRoomStayCandidates($roomStayCandidates)
            ->setStayDateRange($stayDateRange)
            ->setImportanceType($importanceType);
    }
    /**
     * Get HotelRef value
     * @return \StructType\HotelRef|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @param \StructType\HotelRef $hotelRef
     * @return \StructType\Criterion
     */
    public function setHotelRef(\StructType\HotelRef $hotelRef = null)
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Get HotelRefs value
     * @return \StructType\HotelRefs|null
     */
    public function getHotelRefs()
    {
        return $this->HotelRefs;
    }
    /**
     * Set HotelRefs value
     * @param \StructType\HotelRefs $hotelRefs
     * @return \StructType\Criterion
     */
    public function setHotelRefs(\StructType\HotelRefs $hotelRefs = null)
    {
        $this->HotelRefs = $hotelRefs;
        return $this;
    }
    /**
     * Get PackageRef value
     * @return \StructType\PackageRef|null
     */
    public function getPackageRef()
    {
        return $this->PackageRef;
    }
    /**
     * Set PackageRef value
     * @param \StructType\PackageRef $packageRef
     * @return \StructType\Criterion
     */
    public function setPackageRef(\StructType\PackageRef $packageRef = null)
    {
        $this->PackageRef = $packageRef;
        return $this;
    }
    /**
     * Get PackageRefs value
     * @return \StructType\PackageRefs|null
     */
    public function getPackageRefs()
    {
        return $this->PackageRefs;
    }
    /**
     * Set PackageRefs value
     * @param \StructType\PackageRefs $packageRefs
     * @return \StructType\Criterion
     */
    public function setPackageRefs(\StructType\PackageRefs $packageRefs = null)
    {
        $this->PackageRefs = $packageRefs;
        return $this;
    }
    /**
     * Get RatePlanCandidates value
     * @return \StructType\RatePlanCandidates|null
     */
    public function getRatePlanCandidates()
    {
        return $this->RatePlanCandidates;
    }
    /**
     * Set RatePlanCandidates value
     * @param \StructType\RatePlanCandidates $ratePlanCandidates
     * @return \StructType\Criterion
     */
    public function setRatePlanCandidates(\StructType\RatePlanCandidates $ratePlanCandidates = null)
    {
        $this->RatePlanCandidates = $ratePlanCandidates;
        return $this;
    }
    /**
     * Get RateRange value
     * @return \StructType\RateRange|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * Set RateRange value
     * @param \StructType\RateRange $rateRange
     * @return \StructType\Criterion
     */
    public function setRateRange(\StructType\RateRange $rateRange = null)
    {
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Get RoomStayCandidates value
     * @return \StructType\RoomStayCandidates|null
     */
    public function getRoomStayCandidates()
    {
        return $this->RoomStayCandidates;
    }
    /**
     * Set RoomStayCandidates value
     * @param \StructType\RoomStayCandidates $roomStayCandidates
     * @return \StructType\Criterion
     */
    public function setRoomStayCandidates(\StructType\RoomStayCandidates $roomStayCandidates = null)
    {
        $this->RoomStayCandidates = $roomStayCandidates;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \StructType\StayDateRange|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \StructType\StayDateRange $stayDateRange
     * @return \StructType\Criterion
     */
    public function setStayDateRange(\StructType\StayDateRange $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get ImportanceType value
     * @return string|null
     */
    public function getImportanceType()
    {
        return $this->ImportanceType;
    }
    /**
     * Set ImportanceType value
     * @param string $importanceType
     * @return \StructType\Criterion
     */
    public function setImportanceType($importanceType = null)
    {
        // validation for constraint: string
        if (!is_null($importanceType) && !is_string($importanceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importanceType, true), gettype($importanceType)), __LINE__);
        }
        $this->ImportanceType = $importanceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Criterion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
