<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cautions StructType
 * @subpackage Structs
 */
class Cautions extends AbstractStructBase
{
    /**
     * The Caution
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Caution;
    /**
     * Constructor method for Cautions
     * @uses Cautions::setCaution()
     * @param string[] $caution
     */
    public function __construct(array $caution = array())
    {
        $this
            ->setCaution($caution);
    }
    /**
     * Get Caution value
     * @return string[]|null
     */
    public function getCaution()
    {
        return $this->Caution;
    }
    /**
     * This method is responsible for validating the values passed to the setCaution method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCaution method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCautionForArrayConstraintsFromSetCaution(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cautionsCautionItem) {
            // validation for constraint: itemType
            if (!is_string($cautionsCautionItem)) {
                $invalidValues[] = is_object($cautionsCautionItem) ? get_class($cautionsCautionItem) : sprintf('%s(%s)', gettype($cautionsCautionItem), var_export($cautionsCautionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Caution property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Caution value
     * @throws \InvalidArgumentException
     * @param string[] $caution
     * @return \StructType\Cautions
     */
    public function setCaution(array $caution = array())
    {
        // validation for constraint: array
        if ('' !== ($cautionArrayErrorMessage = self::validateCautionForArrayConstraintsFromSetCaution($caution))) {
            throw new \InvalidArgumentException($cautionArrayErrorMessage, __LINE__);
        }
        $this->Caution = $caution;
        return $this;
    }
    /**
     * Add item to Caution value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Cautions
     */
    public function addToCaution($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Caution property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Caution[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Cautions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
