<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingChannel StructType
 * @subpackage Structs
 */
class BookingChannel extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\CompanyName
     */
    public $CompanyName;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Primary
     * @var bool
     */
    public $Primary;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * Constructor method for BookingChannel
     * @uses BookingChannel::setCompanyName()
     * @uses BookingChannel::setCode()
     * @uses BookingChannel::setPrimary()
     * @uses BookingChannel::setType()
     * @param \StructType\CompanyName $companyName
     * @param string $code
     * @param bool $primary
     * @param string $type
     */
    public function __construct(\StructType\CompanyName $companyName = null, $code = null, $primary = null, $type = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setCode($code)
            ->setPrimary($primary)
            ->setType($type);
    }
    /**
     * Get CompanyName value
     * @return \StructType\CompanyName|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \StructType\CompanyName $companyName
     * @return \StructType\BookingChannel
     */
    public function setCompanyName(\StructType\CompanyName $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\BookingChannel
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Primary value
     * @return bool|null
     */
    public function getPrimary()
    {
        return $this->Primary;
    }
    /**
     * Set Primary value
     * @param bool $primary
     * @return \StructType\BookingChannel
     */
    public function setPrimary($primary = null)
    {
        // validation for constraint: boolean
        if (!is_null($primary) && !is_bool($primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($primary, true), gettype($primary)), __LINE__);
        }
        $this->Primary = $primary;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\BookingChannel
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingChannel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
