<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Affiliations StructType
 * @subpackage Structs
 */
class Affiliations extends AbstractStructBase
{
    /**
     * The Organization
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Organization[]
     */
    public $Organization;
    /**
     * Constructor method for Affiliations
     * @uses Affiliations::setOrganization()
     * @param \StructType\Organization[] $organization
     */
    public function __construct(array $organization = array())
    {
        $this
            ->setOrganization($organization);
    }
    /**
     * Get Organization value
     * @return \StructType\Organization[]|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganizationForArrayConstraintsFromSetOrganization(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsOrganizationItem) {
            // validation for constraint: itemType
            if (!$affiliationsOrganizationItem instanceof \StructType\Organization) {
                $invalidValues[] = is_object($affiliationsOrganizationItem) ? get_class($affiliationsOrganizationItem) : sprintf('%s(%s)', gettype($affiliationsOrganizationItem), var_export($affiliationsOrganizationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization property can only contain items of type \StructType\Organization, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization value
     * @throws \InvalidArgumentException
     * @param \StructType\Organization[] $organization
     * @return \StructType\Affiliations
     */
    public function setOrganization(array $organization = array())
    {
        // validation for constraint: array
        if ('' !== ($organizationArrayErrorMessage = self::validateOrganizationForArrayConstraintsFromSetOrganization($organization))) {
            throw new \InvalidArgumentException($organizationArrayErrorMessage, __LINE__);
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Add item to Organization value
     * @throws \InvalidArgumentException
     * @param \StructType\Organization $item
     * @return \StructType\Affiliations
     */
    public function addToOrganization(\StructType\Organization $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Organization) {
            throw new \InvalidArgumentException(sprintf('The Organization property can only contain items of type \StructType\Organization, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Affiliations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
