<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for View ServiceType
 * @subpackage Services
 */
class View extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named viewReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_ReadRQ $oTA_ReadRQ
     * @return \StructType\OTA_ResRetrieveRS|bool
     */
    public function viewReservation(\StructType\OTA_ReadRQ $oTA_ReadRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->viewReservation($oTA_ReadRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OTA_ResRetrieveRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
