<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Hotel ServiceType
 * @subpackage Services
 */
class Hotel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named hotelAvailabilityAndRates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelAvailRQ $oTA_HotelAvailRQ
     * @return \StructType\OTA_HotelAvailRS|bool
     */
    public function hotelAvailabilityAndRates(\StructType\OTA_HotelAvailRQ $oTA_HotelAvailRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->hotelAvailabilityAndRates($oTA_HotelAvailRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OTA_HotelAvailRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
