<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorMessages StructType
 * @subpackage Structs
 */
class VendorMessages extends AbstractStructBase
{
    /**
     * The VendorMessage
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorMessage[]
     */
    public $VendorMessage;
    /**
     * Constructor method for VendorMessages
     * @uses VendorMessages::setVendorMessage()
     * @param \StructType\VendorMessage[] $vendorMessage
     */
    public function __construct(array $vendorMessage = array())
    {
        $this
            ->setVendorMessage($vendorMessage);
    }
    /**
     * Get VendorMessage value
     * @return \StructType\VendorMessage[]|null
     */
    public function getVendorMessage()
    {
        return $this->VendorMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorMessageForArrayConstraintsFromSetVendorMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorMessagesVendorMessageItem) {
            // validation for constraint: itemType
            if (!$vendorMessagesVendorMessageItem instanceof \StructType\VendorMessage) {
                $invalidValues[] = is_object($vendorMessagesVendorMessageItem) ? get_class($vendorMessagesVendorMessageItem) : sprintf('%s(%s)', gettype($vendorMessagesVendorMessageItem), var_export($vendorMessagesVendorMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorMessage property can only contain items of type \StructType\VendorMessage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorMessage[] $vendorMessage
     * @return \StructType\VendorMessages
     */
    public function setVendorMessage(array $vendorMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorMessageArrayErrorMessage = self::validateVendorMessageForArrayConstraintsFromSetVendorMessage($vendorMessage))) {
            throw new \InvalidArgumentException($vendorMessageArrayErrorMessage, __LINE__);
        }
        $this->VendorMessage = $vendorMessage;
        return $this;
    }
    /**
     * Add item to VendorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorMessage $item
     * @return \StructType\VendorMessages
     */
    public function addToVendorMessage(\StructType\VendorMessage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorMessage) {
            throw new \InvalidArgumentException(sprintf('The VendorMessage property can only contain items of type \StructType\VendorMessage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VendorMessage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorMessages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
