<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorMessage StructType
 * @subpackage Structs
 */
class VendorMessage extends AbstractStructBase
{
    /**
     * The SubSection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SubSection
     */
    public $SubSection;
    /**
     * The InfoType
     * @var string
     */
    public $InfoType;
    /**
     * Constructor method for VendorMessage
     * @uses VendorMessage::setSubSection()
     * @uses VendorMessage::setInfoType()
     * @param \StructType\SubSection $subSection
     * @param string $infoType
     */
    public function __construct(\StructType\SubSection $subSection = null, $infoType = null)
    {
        $this
            ->setSubSection($subSection)
            ->setInfoType($infoType);
    }
    /**
     * Get SubSection value
     * @return \StructType\SubSection|null
     */
    public function getSubSection()
    {
        return $this->SubSection;
    }
    /**
     * Set SubSection value
     * @param \StructType\SubSection $subSection
     * @return \StructType\VendorMessage
     */
    public function setSubSection(\StructType\SubSection $subSection = null)
    {
        $this->SubSection = $subSection;
        return $this;
    }
    /**
     * Get InfoType value
     * @return string|null
     */
    public function getInfoType()
    {
        return $this->InfoType;
    }
    /**
     * Set InfoType value
     * @param string $infoType
     * @return \StructType\VendorMessage
     */
    public function setInfoType($infoType = null)
    {
        // validation for constraint: string
        if (!is_null($infoType) && !is_string($infoType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoType, true), gettype($infoType)), __LINE__);
        }
        $this->InfoType = $infoType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
