<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRequest StructType
 * @subpackage Structs
 */
class SpecialRequest extends AbstractStructBase
{
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The RequestCode
     * @var int
     */
    public $RequestCode;
    /**
     * Constructor method for SpecialRequest
     * @uses SpecialRequest::setText()
     * @uses SpecialRequest::setName()
     * @uses SpecialRequest::setRequestCode()
     * @param string $text
     * @param string $name
     * @param int $requestCode
     */
    public function __construct($text = null, $name = null, $requestCode = null)
    {
        $this
            ->setText($text)
            ->setName($name)
            ->setRequestCode($requestCode);
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\SpecialRequest
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SpecialRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RequestCode value
     * @return int|null
     */
    public function getRequestCode()
    {
        return $this->RequestCode;
    }
    /**
     * Set RequestCode value
     * @param int $requestCode
     * @return \StructType\SpecialRequest
     */
    public function setRequestCode($requestCode = null)
    {
        // validation for constraint: int
        if (!is_null($requestCode) && !(is_int($requestCode) || ctype_digit($requestCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestCode, true), gettype($requestCode)), __LINE__);
        }
        $this->RequestCode = $requestCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
