<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypes StructType
 * @subpackage Structs
 */
class RoomTypes extends AbstractStructBase
{
    /**
     * The RoomType
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomType[]
     */
    public $RoomType;
    /**
     * Constructor method for RoomTypes
     * @uses RoomTypes::setRoomType()
     * @param \StructType\RoomType[] $roomType
     */
    public function __construct(array $roomType = array())
    {
        $this
            ->setRoomType($roomType);
    }
    /**
     * Get RoomType value
     * @return \StructType\RoomType[]|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomTypeForArrayConstraintsFromSetRoomType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomTypesRoomTypeItem) {
            // validation for constraint: itemType
            if (!$roomTypesRoomTypeItem instanceof \StructType\RoomType) {
                $invalidValues[] = is_object($roomTypesRoomTypeItem) ? get_class($roomTypesRoomTypeItem) : sprintf('%s(%s)', gettype($roomTypesRoomTypeItem), var_export($roomTypesRoomTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomType property can only contain items of type \StructType\RoomType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomType value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomType[] $roomType
     * @return \StructType\RoomTypes
     */
    public function setRoomType(array $roomType = array())
    {
        // validation for constraint: array
        if ('' !== ($roomTypeArrayErrorMessage = self::validateRoomTypeForArrayConstraintsFromSetRoomType($roomType))) {
            throw new \InvalidArgumentException($roomTypeArrayErrorMessage, __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Add item to RoomType value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomType $item
     * @return \StructType\RoomTypes
     */
    public function addToRoomType(\StructType\RoomType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomType) {
            throw new \InvalidArgumentException(sprintf('The RoomType property can only contain items of type \StructType\RoomType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomTypes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
