<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomType StructType
 * Meta information extracted from the WSDL
 * - type: xs:string
 * @subpackage Structs
 */
class RoomType extends AbstractStructBase
{
    /**
     * The AdditionalDetails
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\AdditionalDetails
     */
    public $AdditionalDetails;
    /**
     * The Amenities
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Amenities
     */
    public $Amenities;
    /**
     * The RoomDescription
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RoomDescription
     */
    public $RoomDescription;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The IsRoom
     * @var bool
     */
    public $IsRoom;
    /**
     * The NumberOfUnits
     * @var int
     */
    public $NumberOfUnits;
    /**
     * Constructor method for RoomType
     * @uses RoomType::setAdditionalDetails()
     * @uses RoomType::setAmenities()
     * @uses RoomType::setRoomDescription()
     * @uses RoomType::setRoomTypeCode()
     * @uses RoomType::setIsRoom()
     * @uses RoomType::setNumberOfUnits()
     * @param \StructType\AdditionalDetails $additionalDetails
     * @param \StructType\Amenities $amenities
     * @param \StructType\RoomDescription $roomDescription
     * @param string $roomTypeCode
     * @param bool $isRoom
     * @param int $numberOfUnits
     */
    public function __construct(\StructType\AdditionalDetails $additionalDetails = null, \StructType\Amenities $amenities = null, \StructType\RoomDescription $roomDescription = null, $roomTypeCode = null, $isRoom = null, $numberOfUnits = null)
    {
        $this
            ->setAdditionalDetails($additionalDetails)
            ->setAmenities($amenities)
            ->setRoomDescription($roomDescription)
            ->setRoomTypeCode($roomTypeCode)
            ->setIsRoom($isRoom)
            ->setNumberOfUnits($numberOfUnits);
    }
    /**
     * Get AdditionalDetails value
     * @return \StructType\AdditionalDetails|null
     */
    public function getAdditionalDetails()
    {
        return $this->AdditionalDetails;
    }
    /**
     * Set AdditionalDetails value
     * @param \StructType\AdditionalDetails $additionalDetails
     * @return \StructType\RoomType
     */
    public function setAdditionalDetails(\StructType\AdditionalDetails $additionalDetails = null)
    {
        $this->AdditionalDetails = $additionalDetails;
        return $this;
    }
    /**
     * Get Amenities value
     * @return \StructType\Amenities|null
     */
    public function getAmenities()
    {
        return $this->Amenities;
    }
    /**
     * Set Amenities value
     * @param \StructType\Amenities $amenities
     * @return \StructType\RoomType
     */
    public function setAmenities(\StructType\Amenities $amenities = null)
    {
        $this->Amenities = $amenities;
        return $this;
    }
    /**
     * Get RoomDescription value
     * @return \StructType\RoomDescription|null
     */
    public function getRoomDescription()
    {
        return $this->RoomDescription;
    }
    /**
     * Set RoomDescription value
     * @param \StructType\RoomDescription $roomDescription
     * @return \StructType\RoomType
     */
    public function setRoomDescription(\StructType\RoomDescription $roomDescription = null)
    {
        $this->RoomDescription = $roomDescription;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get IsRoom value
     * @return bool|null
     */
    public function getIsRoom()
    {
        return $this->IsRoom;
    }
    /**
     * Set IsRoom value
     * @param bool $isRoom
     * @return \StructType\RoomType
     */
    public function setIsRoom($isRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoom) && !is_bool($isRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoom, true), gettype($isRoom)), __LINE__);
        }
        $this->IsRoom = $isRoom;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
