<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayCandidate StructType
 * @subpackage Structs
 */
class RoomStayCandidate extends AbstractStructBase
{
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\GuestCounts
     */
    public $GuestCounts;
    /**
     * The IsAlternate
     * @var bool
     */
    public $IsAlternate;
    /**
     * The BedTypeCode
     * @var int
     */
    public $BedTypeCode;
    /**
     * The NonSmoking
     * @var bool
     */
    public $NonSmoking;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The RatePlanCandidateRPH
     * @var int
     */
    public $RatePlanCandidateRPH;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The RoomViewCode
     * @var int
     */
    public $RoomViewCode;
    /**
     * The RPH
     * @var int
     */
    public $RPH;
    /**
     * Constructor method for RoomStayCandidate
     * @uses RoomStayCandidate::setGuestCounts()
     * @uses RoomStayCandidate::setIsAlternate()
     * @uses RoomStayCandidate::setBedTypeCode()
     * @uses RoomStayCandidate::setNonSmoking()
     * @uses RoomStayCandidate::setQuantity()
     * @uses RoomStayCandidate::setRatePlanCandidateRPH()
     * @uses RoomStayCandidate::setRoomTypeCode()
     * @uses RoomStayCandidate::setRoomViewCode()
     * @uses RoomStayCandidate::setRPH()
     * @param \StructType\GuestCounts $guestCounts
     * @param bool $isAlternate
     * @param int $bedTypeCode
     * @param bool $nonSmoking
     * @param int $quantity
     * @param int $ratePlanCandidateRPH
     * @param string $roomTypeCode
     * @param int $roomViewCode
     * @param int $rPH
     */
    public function __construct(\StructType\GuestCounts $guestCounts = null, $isAlternate = null, $bedTypeCode = null, $nonSmoking = null, $quantity = null, $ratePlanCandidateRPH = null, $roomTypeCode = null, $roomViewCode = null, $rPH = null)
    {
        $this
            ->setGuestCounts($guestCounts)
            ->setIsAlternate($isAlternate)
            ->setBedTypeCode($bedTypeCode)
            ->setNonSmoking($nonSmoking)
            ->setQuantity($quantity)
            ->setRatePlanCandidateRPH($ratePlanCandidateRPH)
            ->setRoomTypeCode($roomTypeCode)
            ->setRoomViewCode($roomViewCode)
            ->setRPH($rPH);
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCounts|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCounts $guestCounts
     * @return \StructType\RoomStayCandidate
     */
    public function setGuestCounts(\StructType\GuestCounts $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get IsAlternate value
     * @return bool|null
     */
    public function getIsAlternate()
    {
        return $this->IsAlternate;
    }
    /**
     * Set IsAlternate value
     * @param bool $isAlternate
     * @return \StructType\RoomStayCandidate
     */
    public function setIsAlternate($isAlternate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternate) && !is_bool($isAlternate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlternate, true), gettype($isAlternate)), __LINE__);
        }
        $this->IsAlternate = $isAlternate;
        return $this;
    }
    /**
     * Get BedTypeCode value
     * @return int|null
     */
    public function getBedTypeCode()
    {
        return $this->BedTypeCode;
    }
    /**
     * Set BedTypeCode value
     * @param int $bedTypeCode
     * @return \StructType\RoomStayCandidate
     */
    public function setBedTypeCode($bedTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($bedTypeCode) && !(is_int($bedTypeCode) || ctype_digit($bedTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bedTypeCode, true), gettype($bedTypeCode)), __LINE__);
        }
        $this->BedTypeCode = $bedTypeCode;
        return $this;
    }
    /**
     * Get NonSmoking value
     * @return bool|null
     */
    public function getNonSmoking()
    {
        return $this->NonSmoking;
    }
    /**
     * Set NonSmoking value
     * @param bool $nonSmoking
     * @return \StructType\RoomStayCandidate
     */
    public function setNonSmoking($nonSmoking = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonSmoking) && !is_bool($nonSmoking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nonSmoking, true), gettype($nonSmoking)), __LINE__);
        }
        $this->NonSmoking = $nonSmoking;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\RoomStayCandidate
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RatePlanCandidateRPH value
     * @return int|null
     */
    public function getRatePlanCandidateRPH()
    {
        return $this->RatePlanCandidateRPH;
    }
    /**
     * Set RatePlanCandidateRPH value
     * @param int $ratePlanCandidateRPH
     * @return \StructType\RoomStayCandidate
     */
    public function setRatePlanCandidateRPH($ratePlanCandidateRPH = null)
    {
        // validation for constraint: int
        if (!is_null($ratePlanCandidateRPH) && !(is_int($ratePlanCandidateRPH) || ctype_digit($ratePlanCandidateRPH))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ratePlanCandidateRPH, true), gettype($ratePlanCandidateRPH)), __LINE__);
        }
        $this->RatePlanCandidateRPH = $ratePlanCandidateRPH;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomStayCandidate
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get RoomViewCode value
     * @return int|null
     */
    public function getRoomViewCode()
    {
        return $this->RoomViewCode;
    }
    /**
     * Set RoomViewCode value
     * @param int $roomViewCode
     * @return \StructType\RoomStayCandidate
     */
    public function setRoomViewCode($roomViewCode = null)
    {
        // validation for constraint: int
        if (!is_null($roomViewCode) && !(is_int($roomViewCode) || ctype_digit($roomViewCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roomViewCode, true), gettype($roomViewCode)), __LINE__);
        }
        $this->RoomViewCode = $roomViewCode;
        return $this;
    }
    /**
     * Get RPH value
     * @return int|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param int $rPH
     * @return \StructType\RoomStayCandidate
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: int
        if (!is_null($rPH) && !(is_int($rPH) || ctype_digit($rPH))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStayCandidate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
