<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStay StructType
 * @subpackage Structs
 */
class RoomStay extends AbstractStructBase
{
    /**
     * The RoomTypes
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RoomTypes
     */
    public $RoomTypes;
    /**
     * The RoomRates
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RoomRates
     */
    public $RoomRates;
    /**
     * The GuestCounts
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\GuestCounts
     */
    public $GuestCounts;
    /**
     * The TimeSpan
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\TimeSpan
     */
    public $TimeSpan;
    /**
     * The Guarantee
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Guarantee
     */
    public $Guarantee;
    /**
     * The BasicPropertyInfo
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\BasicPropertyInfo
     */
    public $BasicPropertyInfo;
    /**
     * The ResGuestRPHs
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\ResGuestRPHs
     */
    public $ResGuestRPHs;
    /**
     * The RatePlans
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\RatePlans
     */
    public $RatePlans;
    /**
     * The SpecialRequests
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\SpecialRequests
     */
    public $SpecialRequests;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\CancelPenalties
     */
    public $CancelPenalties;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Total
     */
    public $Total;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Comments
     */
    public $Comments;
    /**
     * The IsAlternate
     * @var bool
     */
    public $IsAlternate;
    /**
     * The indexNumber
     * @var int
     */
    public $indexNumber;
    /**
     * The RoomStayStatus
     * @var string
     */
    public $RoomStayStatus;
    /**
     * Constructor method for RoomStay
     * @uses RoomStay::setRoomTypes()
     * @uses RoomStay::setRoomRates()
     * @uses RoomStay::setGuestCounts()
     * @uses RoomStay::setTimeSpan()
     * @uses RoomStay::setGuarantee()
     * @uses RoomStay::setBasicPropertyInfo()
     * @uses RoomStay::setResGuestRPHs()
     * @uses RoomStay::setRatePlans()
     * @uses RoomStay::setSpecialRequests()
     * @uses RoomStay::setCancelPenalties()
     * @uses RoomStay::setTotal()
     * @uses RoomStay::setComments()
     * @uses RoomStay::setIsAlternate()
     * @uses RoomStay::setIndexNumber()
     * @uses RoomStay::setRoomStayStatus()
     * @param \StructType\RoomTypes $roomTypes
     * @param \StructType\RoomRates $roomRates
     * @param \StructType\GuestCounts $guestCounts
     * @param \StructType\TimeSpan $timeSpan
     * @param \StructType\Guarantee $guarantee
     * @param \StructType\BasicPropertyInfo $basicPropertyInfo
     * @param \StructType\ResGuestRPHs $resGuestRPHs
     * @param \StructType\RatePlans $ratePlans
     * @param \StructType\SpecialRequests $specialRequests
     * @param \StructType\CancelPenalties $cancelPenalties
     * @param \StructType\Total $total
     * @param \StructType\Comments $comments
     * @param bool $isAlternate
     * @param int $indexNumber
     * @param string $roomStayStatus
     */
    public function __construct(\StructType\RoomTypes $roomTypes = null, \StructType\RoomRates $roomRates = null, \StructType\GuestCounts $guestCounts = null, \StructType\TimeSpan $timeSpan = null, \StructType\Guarantee $guarantee = null, \StructType\BasicPropertyInfo $basicPropertyInfo = null, \StructType\ResGuestRPHs $resGuestRPHs = null, \StructType\RatePlans $ratePlans = null, \StructType\SpecialRequests $specialRequests = null, \StructType\CancelPenalties $cancelPenalties = null, \StructType\Total $total = null, \StructType\Comments $comments = null, $isAlternate = null, $indexNumber = null, $roomStayStatus = null)
    {
        $this
            ->setRoomTypes($roomTypes)
            ->setRoomRates($roomRates)
            ->setGuestCounts($guestCounts)
            ->setTimeSpan($timeSpan)
            ->setGuarantee($guarantee)
            ->setBasicPropertyInfo($basicPropertyInfo)
            ->setResGuestRPHs($resGuestRPHs)
            ->setRatePlans($ratePlans)
            ->setSpecialRequests($specialRequests)
            ->setCancelPenalties($cancelPenalties)
            ->setTotal($total)
            ->setComments($comments)
            ->setIsAlternate($isAlternate)
            ->setIndexNumber($indexNumber)
            ->setRoomStayStatus($roomStayStatus);
    }
    /**
     * Get RoomTypes value
     * @return \StructType\RoomTypes|null
     */
    public function getRoomTypes()
    {
        return $this->RoomTypes;
    }
    /**
     * Set RoomTypes value
     * @param \StructType\RoomTypes $roomTypes
     * @return \StructType\RoomStay
     */
    public function setRoomTypes(\StructType\RoomTypes $roomTypes = null)
    {
        $this->RoomTypes = $roomTypes;
        return $this;
    }
    /**
     * Get RoomRates value
     * @return \StructType\RoomRates|null
     */
    public function getRoomRates()
    {
        return $this->RoomRates;
    }
    /**
     * Set RoomRates value
     * @param \StructType\RoomRates $roomRates
     * @return \StructType\RoomStay
     */
    public function setRoomRates(\StructType\RoomRates $roomRates = null)
    {
        $this->RoomRates = $roomRates;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \StructType\GuestCounts|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \StructType\GuestCounts $guestCounts
     * @return \StructType\RoomStay
     */
    public function setGuestCounts(\StructType\GuestCounts $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get TimeSpan value
     * @return \StructType\TimeSpan|null
     */
    public function getTimeSpan()
    {
        return $this->TimeSpan;
    }
    /**
     * Set TimeSpan value
     * @param \StructType\TimeSpan $timeSpan
     * @return \StructType\RoomStay
     */
    public function setTimeSpan(\StructType\TimeSpan $timeSpan = null)
    {
        $this->TimeSpan = $timeSpan;
        return $this;
    }
    /**
     * Get Guarantee value
     * @return \StructType\Guarantee|null
     */
    public function getGuarantee()
    {
        return $this->Guarantee;
    }
    /**
     * Set Guarantee value
     * @param \StructType\Guarantee $guarantee
     * @return \StructType\RoomStay
     */
    public function setGuarantee(\StructType\Guarantee $guarantee = null)
    {
        $this->Guarantee = $guarantee;
        return $this;
    }
    /**
     * Get BasicPropertyInfo value
     * @return \StructType\BasicPropertyInfo|null
     */
    public function getBasicPropertyInfo()
    {
        return $this->BasicPropertyInfo;
    }
    /**
     * Set BasicPropertyInfo value
     * @param \StructType\BasicPropertyInfo $basicPropertyInfo
     * @return \StructType\RoomStay
     */
    public function setBasicPropertyInfo(\StructType\BasicPropertyInfo $basicPropertyInfo = null)
    {
        $this->BasicPropertyInfo = $basicPropertyInfo;
        return $this;
    }
    /**
     * Get ResGuestRPHs value
     * @return \StructType\ResGuestRPHs|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param \StructType\ResGuestRPHs $resGuestRPHs
     * @return \StructType\RoomStay
     */
    public function setResGuestRPHs(\StructType\ResGuestRPHs $resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get RatePlans value
     * @return \StructType\RatePlans|null
     */
    public function getRatePlans()
    {
        return $this->RatePlans;
    }
    /**
     * Set RatePlans value
     * @param \StructType\RatePlans $ratePlans
     * @return \StructType\RoomStay
     */
    public function setRatePlans(\StructType\RatePlans $ratePlans = null)
    {
        $this->RatePlans = $ratePlans;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \StructType\SpecialRequests|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \StructType\SpecialRequests $specialRequests
     * @return \StructType\RoomStay
     */
    public function setSpecialRequests(\StructType\SpecialRequests $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \StructType\CancelPenalties|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \StructType\CancelPenalties $cancelPenalties
     * @return \StructType\RoomStay
     */
    public function setCancelPenalties(\StructType\CancelPenalties $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\Total|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\Total $total
     * @return \StructType\RoomStay
     */
    public function setTotal(\StructType\Total $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Comments value
     * @return \StructType\Comments|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \StructType\Comments $comments
     * @return \StructType\RoomStay
     */
    public function setComments(\StructType\Comments $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get IsAlternate value
     * @return bool|null
     */
    public function getIsAlternate()
    {
        return $this->IsAlternate;
    }
    /**
     * Set IsAlternate value
     * @param bool $isAlternate
     * @return \StructType\RoomStay
     */
    public function setIsAlternate($isAlternate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlternate) && !is_bool($isAlternate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlternate, true), gettype($isAlternate)), __LINE__);
        }
        $this->IsAlternate = $isAlternate;
        return $this;
    }
    /**
     * Get indexNumber value
     * @return int|null
     */
    public function getIndexNumber()
    {
        return $this->indexNumber;
    }
    /**
     * Set indexNumber value
     * @param int $indexNumber
     * @return \StructType\RoomStay
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !(is_int($indexNumber) || ctype_digit($indexNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexNumber, true), gettype($indexNumber)), __LINE__);
        }
        $this->indexNumber = $indexNumber;
        return $this;
    }
    /**
     * Get RoomStayStatus value
     * @return string|null
     */
    public function getRoomStayStatus()
    {
        return $this->RoomStayStatus;
    }
    /**
     * Set RoomStayStatus value
     * @param string $roomStayStatus
     * @return \StructType\RoomStay
     */
    public function setRoomStayStatus($roomStayStatus = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayStatus) && !is_string($roomStayStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayStatus, true), gettype($roomStayStatus)), __LINE__);
        }
        $this->RoomStayStatus = $roomStayStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
