<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRate StructType
 * @subpackage Structs
 */
class RoomRate extends AbstractStructBase
{
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var string
     */
    public $Availability;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Features
     */
    public $Features;
    /**
     * The RatePlanType
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var string
     */
    public $RatePlanType;
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Rates[]
     */
    public $Rates;
    /**
     * The BookingCode
     * @var string
     */
    public $BookingCode;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The NumberOfUnits
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The PromotionCode
     * @var string
     */
    public $PromotionCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The RatePlanID
     * @var string
     */
    public $RatePlanID;
    /**
     * The RoomTypeCode
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * Constructor method for RoomRate
     * @uses RoomRate::setAvailability()
     * @uses RoomRate::setFeatures()
     * @uses RoomRate::setRatePlanType()
     * @uses RoomRate::setRates()
     * @uses RoomRate::setBookingCode()
     * @uses RoomRate::setExpireDate()
     * @uses RoomRate::setNumberOfUnits()
     * @uses RoomRate::setPromotionCode()
     * @uses RoomRate::setRatePlanCode()
     * @uses RoomRate::setRatePlanID()
     * @uses RoomRate::setRoomTypeCode()
     * @uses RoomRate::setEffectiveDate()
     * @param string $availability
     * @param \StructType\Features $features
     * @param string $ratePlanType
     * @param \StructType\Rates[] $rates
     * @param string $bookingCode
     * @param string $expireDate
     * @param int $numberOfUnits
     * @param string $promotionCode
     * @param string $ratePlanCode
     * @param string $ratePlanID
     * @param string $roomTypeCode
     * @param string $effectiveDate
     */
    public function __construct($availability = null, \StructType\Features $features = null, $ratePlanType = null, array $rates = array(), $bookingCode = null, $expireDate = null, $numberOfUnits = null, $promotionCode = null, $ratePlanCode = null, $ratePlanID = null, $roomTypeCode = null, $effectiveDate = null)
    {
        $this
            ->setAvailability($availability)
            ->setFeatures($features)
            ->setRatePlanType($ratePlanType)
            ->setRates($rates)
            ->setBookingCode($bookingCode)
            ->setExpireDate($expireDate)
            ->setNumberOfUnits($numberOfUnits)
            ->setPromotionCode($promotionCode)
            ->setRatePlanCode($ratePlanCode)
            ->setRatePlanID($ratePlanID)
            ->setRoomTypeCode($roomTypeCode)
            ->setEffectiveDate($effectiveDate);
    }
    /**
     * Get Availability value
     * @return string|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @uses \EnumType\AvailabilityStatus::valueIsValid()
     * @uses \EnumType\AvailabilityStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availability
     * @return \StructType\RoomRate
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvailabilityStatus::valueIsValid($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AvailabilityStatus', is_array($availability) ? implode(', ', $availability) : var_export($availability, true), implode(', ', \EnumType\AvailabilityStatus::getValidValues())), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get Features value
     * @return \StructType\Features|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \StructType\Features $features
     * @return \StructType\RoomRate
     */
    public function setFeatures(\StructType\Features $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get RatePlanType value
     * @return string|null
     */
    public function getRatePlanType()
    {
        return $this->RatePlanType;
    }
    /**
     * Set RatePlanType value
     * @param string $ratePlanType
     * @return \StructType\RoomRate
     */
    public function setRatePlanType($ratePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanType) && !is_string($ratePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanType, true), gettype($ratePlanType)), __LINE__);
        }
        $this->RatePlanType = $ratePlanType;
        return $this;
    }
    /**
     * Get Rates value
     * @return \StructType\Rates[]|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * This method is responsible for validating the values passed to the setRates method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRates method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRatesForArrayConstraintsFromSetRates(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRateRatesItem) {
            // validation for constraint: itemType
            if (!$roomRateRatesItem instanceof \StructType\Rates) {
                $invalidValues[] = is_object($roomRateRatesItem) ? get_class($roomRateRatesItem) : sprintf('%s(%s)', gettype($roomRateRatesItem), var_export($roomRateRatesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Rates property can only contain items of type \StructType\Rates, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Rates value
     * @throws \InvalidArgumentException
     * @param \StructType\Rates[] $rates
     * @return \StructType\RoomRate
     */
    public function setRates(array $rates = array())
    {
        // validation for constraint: array
        if ('' !== ($ratesArrayErrorMessage = self::validateRatesForArrayConstraintsFromSetRates($rates))) {
            throw new \InvalidArgumentException($ratesArrayErrorMessage, __LINE__);
        }
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Add item to Rates value
     * @throws \InvalidArgumentException
     * @param \StructType\Rates $item
     * @return \StructType\RoomRate
     */
    public function addToRates(\StructType\Rates $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rates) {
            throw new \InvalidArgumentException(sprintf('The Rates property can only contain items of type \StructType\Rates, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Rates[] = $item;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \StructType\RoomRate
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCode, true), gettype($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\RoomRate
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomRate
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\RoomRate
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\RoomRate
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get RatePlanID value
     * @return string|null
     */
    public function getRatePlanID()
    {
        return $this->RatePlanID;
    }
    /**
     * Set RatePlanID value
     * @param string $ratePlanID
     * @return \StructType\RoomRate
     */
    public function setRatePlanID($ratePlanID = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanID) && !is_string($ratePlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanID, true), gettype($ratePlanID)), __LINE__);
        }
        $this->RatePlanID = $ratePlanID;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomRate
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RoomRate
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
