<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomProfiles StructType
 * @subpackage Structs
 */
class RoomProfiles extends AbstractStructBase
{
    /**
     * The RoomProfile
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomProfile[]
     */
    public $RoomProfile;
    /**
     * Constructor method for RoomProfiles
     * @uses RoomProfiles::setRoomProfile()
     * @param \StructType\RoomProfile[] $roomProfile
     */
    public function __construct(array $roomProfile = array())
    {
        $this
            ->setRoomProfile($roomProfile);
    }
    /**
     * Get RoomProfile value
     * @return \StructType\RoomProfile[]|null
     */
    public function getRoomProfile()
    {
        return $this->RoomProfile;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomProfile method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomProfile method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomProfileForArrayConstraintsFromSetRoomProfile(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomProfilesRoomProfileItem) {
            // validation for constraint: itemType
            if (!$roomProfilesRoomProfileItem instanceof \StructType\RoomProfile) {
                $invalidValues[] = is_object($roomProfilesRoomProfileItem) ? get_class($roomProfilesRoomProfileItem) : sprintf('%s(%s)', gettype($roomProfilesRoomProfileItem), var_export($roomProfilesRoomProfileItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomProfile property can only contain items of type \StructType\RoomProfile, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomProfile[] $roomProfile
     * @return \StructType\RoomProfiles
     */
    public function setRoomProfile(array $roomProfile = array())
    {
        // validation for constraint: array
        if ('' !== ($roomProfileArrayErrorMessage = self::validateRoomProfileForArrayConstraintsFromSetRoomProfile($roomProfile))) {
            throw new \InvalidArgumentException($roomProfileArrayErrorMessage, __LINE__);
        }
        $this->RoomProfile = $roomProfile;
        return $this;
    }
    /**
     * Add item to RoomProfile value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomProfile $item
     * @return \StructType\RoomProfiles
     */
    public function addToRoomProfile(\StructType\RoomProfile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomProfile) {
            throw new \InvalidArgumentException(sprintf('The RoomProfile property can only contain items of type \StructType\RoomProfile, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomProfile[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomProfiles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
