<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequiredPayment StructType
 * Meta information extracted from the WSDL
 * - type: tns:RequiredPayment
 * @subpackage Structs
 */
class RequiredPayment extends AbstractStructBase
{
    /**
     * The AcceptedPayments
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\AcceptedPayments
     */
    public $AcceptedPayments;
    /**
     * The PaymentCode
     * @var string
     */
    public $PaymentCode;
    /**
     * Constructor method for RequiredPayment
     * @uses RequiredPayment::setAcceptedPayments()
     * @uses RequiredPayment::setPaymentCode()
     * @param \StructType\AcceptedPayments $acceptedPayments
     * @param string $paymentCode
     */
    public function __construct(\StructType\AcceptedPayments $acceptedPayments = null, $paymentCode = null)
    {
        $this
            ->setAcceptedPayments($acceptedPayments)
            ->setPaymentCode($paymentCode);
    }
    /**
     * Get AcceptedPayments value
     * @return \StructType\AcceptedPayments|null
     */
    public function getAcceptedPayments()
    {
        return $this->AcceptedPayments;
    }
    /**
     * Set AcceptedPayments value
     * @param \StructType\AcceptedPayments $acceptedPayments
     * @return \StructType\RequiredPayment
     */
    public function setAcceptedPayments(\StructType\AcceptedPayments $acceptedPayments = null)
    {
        $this->AcceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get PaymentCode value
     * @return string|null
     */
    public function getPaymentCode()
    {
        return $this->PaymentCode;
    }
    /**
     * Set PaymentCode value
     * @param string $paymentCode
     * @return \StructType\RequiredPayment
     */
    public function setPaymentCode($paymentCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCode) && !is_string($paymentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCode, true), gettype($paymentCode)), __LINE__);
        }
        $this->PaymentCode = $paymentCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequiredPayment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
