<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RentalCar StructType
 * @subpackage Structs
 */
class RentalCar extends AbstractStructBase
{
    /**
     * The PickUpLocation
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PickUpLocation
     */
    public $PickUpLocation;
    /**
     * The ReturnLocation
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\ReturnLocation
     */
    public $ReturnLocation;
    /**
     * The SupplementCharges
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\SupplementCharges
     */
    public $SupplementCharges;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - ref: tns:Code
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - ref: tns:Name
     * @var string
     */
    public $Name;
    /**
     * The PickUpDateTime
     * Meta information extracted from the WSDL
     * - ref: tns:PickUpDateTime
     * @var string
     */
    public $PickUpDateTime;
    /**
     * The ReturnDateTime
     * Meta information extracted from the WSDL
     * - ref: tns:ReturnDateTime
     * @var string
     */
    public $ReturnDateTime;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for RentalCar
     * @uses RentalCar::setPickUpLocation()
     * @uses RentalCar::setReturnLocation()
     * @uses RentalCar::setSupplementCharges()
     * @uses RentalCar::setCode()
     * @uses RentalCar::setName()
     * @uses RentalCar::setPickUpDateTime()
     * @uses RentalCar::setReturnDateTime()
     * @uses RentalCar::setStatus()
     * @param \StructType\PickUpLocation $pickUpLocation
     * @param \StructType\ReturnLocation $returnLocation
     * @param \StructType\SupplementCharges $supplementCharges
     * @param string $code
     * @param string $name
     * @param string $pickUpDateTime
     * @param string $returnDateTime
     * @param string $status
     */
    public function __construct(\StructType\PickUpLocation $pickUpLocation = null, \StructType\ReturnLocation $returnLocation = null, \StructType\SupplementCharges $supplementCharges = null, $code = null, $name = null, $pickUpDateTime = null, $returnDateTime = null, $status = null)
    {
        $this
            ->setPickUpLocation($pickUpLocation)
            ->setReturnLocation($returnLocation)
            ->setSupplementCharges($supplementCharges)
            ->setCode($code)
            ->setName($name)
            ->setPickUpDateTime($pickUpDateTime)
            ->setReturnDateTime($returnDateTime)
            ->setStatus($status);
    }
    /**
     * Get PickUpLocation value
     * @return \StructType\PickUpLocation|null
     */
    public function getPickUpLocation()
    {
        return $this->PickUpLocation;
    }
    /**
     * Set PickUpLocation value
     * @param \StructType\PickUpLocation $pickUpLocation
     * @return \StructType\RentalCar
     */
    public function setPickUpLocation(\StructType\PickUpLocation $pickUpLocation = null)
    {
        $this->PickUpLocation = $pickUpLocation;
        return $this;
    }
    /**
     * Get ReturnLocation value
     * @return \StructType\ReturnLocation|null
     */
    public function getReturnLocation()
    {
        return $this->ReturnLocation;
    }
    /**
     * Set ReturnLocation value
     * @param \StructType\ReturnLocation $returnLocation
     * @return \StructType\RentalCar
     */
    public function setReturnLocation(\StructType\ReturnLocation $returnLocation = null)
    {
        $this->ReturnLocation = $returnLocation;
        return $this;
    }
    /**
     * Get SupplementCharges value
     * @return \StructType\SupplementCharges|null
     */
    public function getSupplementCharges()
    {
        return $this->SupplementCharges;
    }
    /**
     * Set SupplementCharges value
     * @param \StructType\SupplementCharges $supplementCharges
     * @return \StructType\RentalCar
     */
    public function setSupplementCharges(\StructType\SupplementCharges $supplementCharges = null)
    {
        $this->SupplementCharges = $supplementCharges;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\RentalCar
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\RentalCar
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PickUpDateTime value
     * @return string|null
     */
    public function getPickUpDateTime()
    {
        return $this->PickUpDateTime;
    }
    /**
     * Set PickUpDateTime value
     * @param string $pickUpDateTime
     * @return \StructType\RentalCar
     */
    public function setPickUpDateTime($pickUpDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpDateTime) && !is_string($pickUpDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpDateTime, true), gettype($pickUpDateTime)), __LINE__);
        }
        $this->PickUpDateTime = $pickUpDateTime;
        return $this;
    }
    /**
     * Get ReturnDateTime value
     * @return string|null
     */
    public function getReturnDateTime()
    {
        return $this->ReturnDateTime;
    }
    /**
     * Set ReturnDateTime value
     * @param string $returnDateTime
     * @return \StructType\RentalCar
     */
    public function setReturnDateTime($returnDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($returnDateTime) && !is_string($returnDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnDateTime, true), gettype($returnDateTime)), __LINE__);
        }
        $this->ReturnDateTime = $returnDateTime;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\RentalCar
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RentalCar
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
