<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rate StructType
 * @subpackage Structs
 */
class Rate extends AbstractStructBase
{
    /**
     * The AdditionalGuestAmounts
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\AdditionalGuestAmounts
     */
    public $AdditionalGuestAmounts;
    /**
     * The Base
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Base
     */
    public $Base;
    /**
     * The Discount
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Discount
     */
    public $Discount;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Fees
     */
    public $Fees;
    /**
     * The PaymentPolicies
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PaymentPolicies
     */
    public $PaymentPolicies;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Total
     */
    public $Total;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\TPA_Extensions
     */
    public $TPA_Extensions;
    /**
     * The AgeQualifyingCode
     * @var int
     */
    public $AgeQualifyingCode;
    /**
     * The AvailabilityStatus
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The CachedIndicator
     * @var bool
     */
    public $CachedIndicator;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The GuaranteedInd
     * @var bool
     */
    public $GuaranteedInd;
    /**
     * The MaxAge
     * @var int
     */
    public $MaxAge;
    /**
     * The RateMode
     * @var string
     */
    public $RateMode;
    /**
     * The UnitMultiplier
     * @var int
     */
    public $UnitMultiplier;
    /**
     * The NumberOfUnits
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The RateTimeUnit
     * @var string
     */
    public $RateTimeUnit;
    /**
     * The RateTypeCode
     * @var string
     */
    public $RateTypeCode;
    /**
     * Constructor method for Rate
     * @uses Rate::setAdditionalGuestAmounts()
     * @uses Rate::setBase()
     * @uses Rate::setDiscount()
     * @uses Rate::setFees()
     * @uses Rate::setPaymentPolicies()
     * @uses Rate::setTotal()
     * @uses Rate::setTPA_Extensions()
     * @uses Rate::setAgeQualifyingCode()
     * @uses Rate::setAvailabilityStatus()
     * @uses Rate::setCachedIndicator()
     * @uses Rate::setEffectiveDate()
     * @uses Rate::setExpireDate()
     * @uses Rate::setGuaranteedInd()
     * @uses Rate::setMaxAge()
     * @uses Rate::setRateMode()
     * @uses Rate::setUnitMultiplier()
     * @uses Rate::setNumberOfUnits()
     * @uses Rate::setRateTimeUnit()
     * @uses Rate::setRateTypeCode()
     * @param \StructType\AdditionalGuestAmounts $additionalGuestAmounts
     * @param \StructType\Base $base
     * @param \StructType\Discount $discount
     * @param \StructType\Fees $fees
     * @param \StructType\PaymentPolicies $paymentPolicies
     * @param \StructType\Total $total
     * @param \StructType\TPA_Extensions $tPA_Extensions
     * @param int $ageQualifyingCode
     * @param string $availabilityStatus
     * @param bool $cachedIndicator
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $guaranteedInd
     * @param int $maxAge
     * @param string $rateMode
     * @param int $unitMultiplier
     * @param int $numberOfUnits
     * @param string $rateTimeUnit
     * @param string $rateTypeCode
     */
    public function __construct(\StructType\AdditionalGuestAmounts $additionalGuestAmounts = null, \StructType\Base $base = null, \StructType\Discount $discount = null, \StructType\Fees $fees = null, \StructType\PaymentPolicies $paymentPolicies = null, \StructType\Total $total = null, \StructType\TPA_Extensions $tPA_Extensions = null, $ageQualifyingCode = null, $availabilityStatus = null, $cachedIndicator = null, $effectiveDate = null, $expireDate = null, $guaranteedInd = null, $maxAge = null, $rateMode = null, $unitMultiplier = null, $numberOfUnits = null, $rateTimeUnit = null, $rateTypeCode = null)
    {
        $this
            ->setAdditionalGuestAmounts($additionalGuestAmounts)
            ->setBase($base)
            ->setDiscount($discount)
            ->setFees($fees)
            ->setPaymentPolicies($paymentPolicies)
            ->setTotal($total)
            ->setTPA_Extensions($tPA_Extensions)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setAvailabilityStatus($availabilityStatus)
            ->setCachedIndicator($cachedIndicator)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setGuaranteedInd($guaranteedInd)
            ->setMaxAge($maxAge)
            ->setRateMode($rateMode)
            ->setUnitMultiplier($unitMultiplier)
            ->setNumberOfUnits($numberOfUnits)
            ->setRateTimeUnit($rateTimeUnit)
            ->setRateTypeCode($rateTypeCode);
    }
    /**
     * Get AdditionalGuestAmounts value
     * @return \StructType\AdditionalGuestAmounts|null
     */
    public function getAdditionalGuestAmounts()
    {
        return $this->AdditionalGuestAmounts;
    }
    /**
     * Set AdditionalGuestAmounts value
     * @param \StructType\AdditionalGuestAmounts $additionalGuestAmounts
     * @return \StructType\Rate
     */
    public function setAdditionalGuestAmounts(\StructType\AdditionalGuestAmounts $additionalGuestAmounts = null)
    {
        $this->AdditionalGuestAmounts = $additionalGuestAmounts;
        return $this;
    }
    /**
     * Get Base value
     * @return \StructType\Base|null
     */
    public function getBase()
    {
        return $this->Base;
    }
    /**
     * Set Base value
     * @param \StructType\Base $base
     * @return \StructType\Rate
     */
    public function setBase(\StructType\Base $base = null)
    {
        $this->Base = $base;
        return $this;
    }
    /**
     * Get Discount value
     * @return \StructType\Discount|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param \StructType\Discount $discount
     * @return \StructType\Rate
     */
    public function setDiscount(\StructType\Discount $discount = null)
    {
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Fees value
     * @return \StructType\Fees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \StructType\Fees $fees
     * @return \StructType\Rate
     */
    public function setFees(\StructType\Fees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get PaymentPolicies value
     * @return \StructType\PaymentPolicies|null
     */
    public function getPaymentPolicies()
    {
        return $this->PaymentPolicies;
    }
    /**
     * Set PaymentPolicies value
     * @param \StructType\PaymentPolicies $paymentPolicies
     * @return \StructType\Rate
     */
    public function setPaymentPolicies(\StructType\PaymentPolicies $paymentPolicies = null)
    {
        $this->PaymentPolicies = $paymentPolicies;
        return $this;
    }
    /**
     * Get Total value
     * @return \StructType\Total|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \StructType\Total $total
     * @return \StructType\Rate
     */
    public function setTotal(\StructType\Total $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_Extensions|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_Extensions $tPA_Extensions
     * @return \StructType\Rate
     */
    public function setTPA_Extensions(\StructType\TPA_Extensions $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return int|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param int $ageQualifyingCode
     * @return \StructType\Rate
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: int
        if (!is_null($ageQualifyingCode) && !(is_int($ageQualifyingCode) || ctype_digit($ageQualifyingCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\AvailabilityStatus::valueIsValid()
     * @uses \EnumType\AvailabilityStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\Rate
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvailabilityStatus::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AvailabilityStatus', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \EnumType\AvailabilityStatus::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get CachedIndicator value
     * @return bool|null
     */
    public function getCachedIndicator()
    {
        return $this->CachedIndicator;
    }
    /**
     * Set CachedIndicator value
     * @param bool $cachedIndicator
     * @return \StructType\Rate
     */
    public function setCachedIndicator($cachedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($cachedIndicator) && !is_bool($cachedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cachedIndicator, true), gettype($cachedIndicator)), __LINE__);
        }
        $this->CachedIndicator = $cachedIndicator;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Rate
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Rate
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get GuaranteedInd value
     * @return bool|null
     */
    public function getGuaranteedInd()
    {
        return $this->GuaranteedInd;
    }
    /**
     * Set GuaranteedInd value
     * @param bool $guaranteedInd
     * @return \StructType\Rate
     */
    public function setGuaranteedInd($guaranteedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($guaranteedInd) && !is_bool($guaranteedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($guaranteedInd, true), gettype($guaranteedInd)), __LINE__);
        }
        $this->GuaranteedInd = $guaranteedInd;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\Rate
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get RateMode value
     * @return string|null
     */
    public function getRateMode()
    {
        return $this->RateMode;
    }
    /**
     * Set RateMode value
     * @param string $rateMode
     * @return \StructType\Rate
     */
    public function setRateMode($rateMode = null)
    {
        // validation for constraint: string
        if (!is_null($rateMode) && !is_string($rateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateMode, true), gettype($rateMode)), __LINE__);
        }
        $this->RateMode = $rateMode;
        return $this;
    }
    /**
     * Get UnitMultiplier value
     * @return int|null
     */
    public function getUnitMultiplier()
    {
        return $this->UnitMultiplier;
    }
    /**
     * Set UnitMultiplier value
     * @param int $unitMultiplier
     * @return \StructType\Rate
     */
    public function setUnitMultiplier($unitMultiplier = null)
    {
        // validation for constraint: int
        if (!is_null($unitMultiplier) && !(is_int($unitMultiplier) || ctype_digit($unitMultiplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitMultiplier, true), gettype($unitMultiplier)), __LINE__);
        }
        $this->UnitMultiplier = $unitMultiplier;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\Rate
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get RateTimeUnit value
     * @return string|null
     */
    public function getRateTimeUnit()
    {
        return $this->RateTimeUnit;
    }
    /**
     * Set RateTimeUnit value
     * @param string $rateTimeUnit
     * @return \StructType\Rate
     */
    public function setRateTimeUnit($rateTimeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($rateTimeUnit) && !is_string($rateTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateTimeUnit, true), gettype($rateTimeUnit)), __LINE__);
        }
        $this->RateTimeUnit = $rateTimeUnit;
        return $this;
    }
    /**
     * Get RateTypeCode value
     * @return string|null
     */
    public function getRateTypeCode()
    {
        return $this->RateTypeCode;
    }
    /**
     * Set RateTypeCode value
     * @param string $rateTypeCode
     * @return \StructType\Rate
     */
    public function setRateTypeCode($rateTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($rateTypeCode) && !is_string($rateTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateTypeCode, true), gettype($rateTypeCode)), __LINE__);
        }
        $this->RateTypeCode = $rateTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Rate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
