<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Primary StructType
 * @subpackage Structs
 */
class Primary extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $Address;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerLoyaltyProgram[]
     */
    public $CustLoyalty;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Document
     */
    public $Document;
    /**
     * The PersonName
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\PersonName
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $Telephone;
    /**
     * Constructor method for Primary
     * @uses Primary::setAddress()
     * @uses Primary::setCustLoyalty()
     * @uses Primary::setEmail()
     * @uses Primary::setDocument()
     * @uses Primary::setPersonName()
     * @uses Primary::setTelephone()
     * @param \StructType\Address $address
     * @param \StructType\CustomerLoyaltyProgram[] $custLoyalty
     * @param string $email
     * @param \StructType\Document $document
     * @param \StructType\PersonName $personName
     * @param \StructType\Telephone $telephone
     */
    public function __construct(\StructType\Address $address = null, array $custLoyalty = array(), $email = null, \StructType\Document $document = null, \StructType\PersonName $personName = null, \StructType\Telephone $telephone = null)
    {
        $this
            ->setAddress($address)
            ->setCustLoyalty($custLoyalty)
            ->setEmail($email)
            ->setDocument($document)
            ->setPersonName($personName)
            ->setTelephone($telephone);
    }
    /**
     * Get Address value
     * @return \StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\Address $address
     * @return \StructType\Primary
     */
    public function setAddress(\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustomerLoyaltyProgram[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * This method is responsible for validating the values passed to the setCustLoyalty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustLoyalty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $primaryCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$primaryCustLoyaltyItem instanceof \StructType\CustomerLoyaltyProgram) {
                $invalidValues[] = is_object($primaryCustLoyaltyItem) ? get_class($primaryCustLoyaltyItem) : sprintf('%s(%s)', gettype($primaryCustLoyaltyItem), var_export($primaryCustLoyaltyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustLoyalty property can only contain items of type \StructType\CustomerLoyaltyProgram, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerLoyaltyProgram[] $custLoyalty
     * @return \StructType\Primary
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        // validation for constraint: array
        if ('' !== ($custLoyaltyArrayErrorMessage = self::validateCustLoyaltyForArrayConstraintsFromSetCustLoyalty($custLoyalty))) {
            throw new \InvalidArgumentException($custLoyaltyArrayErrorMessage, __LINE__);
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerLoyaltyProgram $item
     * @return \StructType\Primary
     */
    public function addToCustLoyalty(\StructType\CustomerLoyaltyProgram $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerLoyaltyProgram) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of type \StructType\CustomerLoyaltyProgram, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Primary
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\Document|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \StructType\Document $document
     * @return \StructType\Primary
     */
    public function setDocument(\StructType\Document $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \StructType\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \StructType\PersonName $personName
     * @return \StructType\Primary
     */
    public function setPersonName(\StructType\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\Telephone $telephone
     * @return \StructType\Primary
     */
    public function setTelephone(\StructType\Telephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Primary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
