<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pingRequest StructType
 * @subpackage Structs
 */
class PingRequest extends AbstractStructBase
{
    /**
     * The EchoData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: ns1:EchoData
     * @var string
     */
    public $EchoData;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * Constructor method for pingRequest
     * @uses PingRequest::setEchoData()
     * @uses PingRequest::setEchoToken()
     * @uses PingRequest::setTarget()
     * @uses PingRequest::setTimestamp()
     * @uses PingRequest::setTransactionIdentifier()
     * @uses PingRequest::setVersion()
     * @param string $echoData
     * @param string $echoToken
     * @param string $target
     * @param string $timestamp
     * @param string $transactionIdentifier
     * @param string $version
     */
    public function __construct($echoData = null, $echoToken = null, $target = null, $timestamp = null, $transactionIdentifier = null, $version = null)
    {
        $this
            ->setEchoData($echoData)
            ->setEchoToken($echoToken)
            ->setTarget($target)
            ->setTimestamp($timestamp)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setVersion($version);
    }
    /**
     * Get EchoData value
     * @return string|null
     */
    public function getEchoData()
    {
        return $this->EchoData;
    }
    /**
     * Set EchoData value
     * @param string $echoData
     * @return \StructType\PingRequest
     */
    public function setEchoData($echoData = null)
    {
        // validation for constraint: string
        if (!is_null($echoData) && !is_string($echoData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoData, true), gettype($echoData)), __LINE__);
        }
        $this->EchoData = $echoData;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \StructType\PingRequest
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($echoToken, true), gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \StructType\PingRequest
     */
    public function setTarget($target = null)
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($target, true), gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\PingRequest
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \StructType\PingRequest
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionIdentifier, true), gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\PingRequest
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
