<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerListItems StructType
 * @subpackage Structs
 */
class PassengerListItems extends AbstractStructBase
{
    /**
     * The PassengerListItem
     * Meta information extracted from the WSDL
     * - form: qualified
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PassengerListItem[]
     */
    public $PassengerListItem;
    /**
     * Constructor method for PassengerListItems
     * @uses PassengerListItems::setPassengerListItem()
     * @param \StructType\PassengerListItem[] $passengerListItem
     */
    public function __construct(array $passengerListItem = array())
    {
        $this
            ->setPassengerListItem($passengerListItem);
    }
    /**
     * Get PassengerListItem value
     * @return \StructType\PassengerListItem[]|null
     */
    public function getPassengerListItem()
    {
        return $this->PassengerListItem;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerListItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerListItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerListItemForArrayConstraintsFromSetPassengerListItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $passengerListItemsPassengerListItemItem) {
            // validation for constraint: itemType
            if (!$passengerListItemsPassengerListItemItem instanceof \StructType\PassengerListItem) {
                $invalidValues[] = is_object($passengerListItemsPassengerListItemItem) ? get_class($passengerListItemsPassengerListItemItem) : sprintf('%s(%s)', gettype($passengerListItemsPassengerListItemItem), var_export($passengerListItemsPassengerListItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerListItem property can only contain items of type \StructType\PassengerListItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerListItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerListItem[] $passengerListItem
     * @return \StructType\PassengerListItems
     */
    public function setPassengerListItem(array $passengerListItem = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerListItemArrayErrorMessage = self::validatePassengerListItemForArrayConstraintsFromSetPassengerListItem($passengerListItem))) {
            throw new \InvalidArgumentException($passengerListItemArrayErrorMessage, __LINE__);
        }
        $this->PassengerListItem = $passengerListItem;
        return $this;
    }
    /**
     * Add item to PassengerListItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PassengerListItem $item
     * @return \StructType\PassengerListItems
     */
    public function addToPassengerListItem(\StructType\PassengerListItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PassengerListItem) {
            throw new \InvalidArgumentException(sprintf('The PassengerListItem property can only contain items of type \StructType\PassengerListItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PassengerListItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PassengerListItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
