<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerListItem StructType
 * @subpackage Structs
 */
class PassengerListItem extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - form: qualified
     * - minOccurs: 0
     * @var \StructType\Name
     */
    public $Name;
    /**
     * The SpecialNeed
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecialNeed[]
     */
    public $SpecialNeed;
    /**
     * The Age
     * @var int
     */
    public $Age;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for PassengerListItem
     * @uses PassengerListItem::setName()
     * @uses PassengerListItem::setSpecialNeed()
     * @uses PassengerListItem::setAge()
     * @uses PassengerListItem::setRPH()
     * @param \StructType\Name $name
     * @param \StructType\SpecialNeed[] $specialNeed
     * @param int $age
     * @param string $rPH
     */
    public function __construct(\StructType\Name $name = null, array $specialNeed = array(), $age = null, $rPH = null)
    {
        $this
            ->setName($name)
            ->setSpecialNeed($specialNeed)
            ->setAge($age)
            ->setRPH($rPH);
    }
    /**
     * Get Name value
     * @return \StructType\Name|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\Name $name
     * @return \StructType\PassengerListItem
     */
    public function setName(\StructType\Name $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SpecialNeed value
     * @return \StructType\SpecialNeed[]|null
     */
    public function getSpecialNeed()
    {
        return $this->SpecialNeed;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialNeed method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialNeed method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialNeedForArrayConstraintsFromSetSpecialNeed(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $passengerListItemSpecialNeedItem) {
            // validation for constraint: itemType
            if (!$passengerListItemSpecialNeedItem instanceof \StructType\SpecialNeed) {
                $invalidValues[] = is_object($passengerListItemSpecialNeedItem) ? get_class($passengerListItemSpecialNeedItem) : sprintf('%s(%s)', gettype($passengerListItemSpecialNeedItem), var_export($passengerListItemSpecialNeedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialNeed property can only contain items of type \StructType\SpecialNeed, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialNeed value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialNeed[] $specialNeed
     * @return \StructType\PassengerListItem
     */
    public function setSpecialNeed(array $specialNeed = array())
    {
        // validation for constraint: array
        if ('' !== ($specialNeedArrayErrorMessage = self::validateSpecialNeedForArrayConstraintsFromSetSpecialNeed($specialNeed))) {
            throw new \InvalidArgumentException($specialNeedArrayErrorMessage, __LINE__);
        }
        $this->SpecialNeed = $specialNeed;
        return $this;
    }
    /**
     * Add item to SpecialNeed value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialNeed $item
     * @return \StructType\PassengerListItem
     */
    public function addToSpecialNeed(\StructType\SpecialNeed $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialNeed) {
            throw new \InvalidArgumentException(sprintf('The SpecialNeed property can only contain items of type \StructType\SpecialNeed, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialNeed[] = $item;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\PassengerListItem
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\PassengerListItem
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PassengerListItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
